/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import org.eclipse.jdt.internal.compiler.batch.Main;

public class FileFinder {
    private static final int INITIAL_SIZE = 10;
    public String[] resultFiles = new String[10];
    public int count = 0;

    public void find(File f, String pattern, boolean verbose) {
        if (verbose) {
            System.out.println(Main.bind("scanning.start", f.getAbsolutePath()));
        }
        this.find0(f, pattern, verbose);
        this.resultFiles = new String[this.count];
        System.arraycopy(this.resultFiles, 0, this.resultFiles, 0, this.count);
    }

    public void find0(File f, String pattern, boolean verbose) {
        if (f.isDirectory()) {
            String[] files = f.list();
            if (files == null) {
                return;
            }
            int i = 0;
            int max = files.length;
            while (i < max) {
                File current = new File(f, files[i]);
                if (current.isDirectory()) {
                    this.find0(current, pattern, verbose);
                } else if (current.getName().toUpperCase().endsWith(pattern)) {
                    int length = this.resultFiles.length;
                    if (length == this.count) {
                        this.resultFiles = new String[length * 2];
                        System.arraycopy(this.resultFiles, 0, this.resultFiles, 0, length);
                    }
                    this.resultFiles[this.count++] = current.getAbsolutePath();
                    if (verbose && this.count % 100 == 0) {
                        System.out.print('.');
                    }
                }
                ++i;
            }
        }
    }
}

