/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.openide.windows.IOFolding;

public final class FoldHandle {
    private final IOFolding.FoldHandleDefinition definition;
    private static final Logger LOG = Logger.getLogger(FoldHandle.class.getName());
    private FoldHandle currentChild;
    private boolean finished = false;

    FoldHandle(IOFolding.FoldHandleDefinition foldHandleDefinition) {
        this.definition = foldHandleDefinition;
    }

    public void finish() {
        this.definition.finish();
        this.finished = true;
    }

    public FoldHandle startFold(boolean bl) {
        this.currentChild = new FoldHandle(this.definition.startFold(bl));
        return this.currentChild;
    }

    public void setExpanded(boolean bl) {
        this.definition.setExpanded(bl);
    }

    public boolean isFinished() {
        return this.finished;
    }

    @CheckForNull
    public FoldHandle getLastNestedFold() {
        return this.currentChild;
    }

    @CheckForNull
    public FoldHandle getCurrentNestedFold() {
        return this.currentChild != null && !this.currentChild.isFinished() ? this.currentChild : null;
    }

    public void silentFinish() {
        if (!this.finished) {
            if (this.currentChild != null && !this.currentChild.finished) {
                this.currentChild.silentFinish();
            }
            this.finish();
        }
    }

    @CheckForNull
    public FoldHandle silentStartFold(boolean bl) {
        if (!this.finished) {
            if (this.currentChild != null && !this.currentChild.finished) {
                this.currentChild.silentFinish();
            }
            return this.startFold(bl);
        }
        LOG.log(Level.FINE, "silentStartFold - already finished");
        return null;
    }
}

