/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;

public class ExpandItem
extends Item {
    ExpandBar parent;
    Control control;
    ImageList imageList;
    int clientHandle;
    int boxHandle;
    int labelHandle;
    int imageHandle;
    boolean expanded;
    int x;
    int y;
    int width;
    int height;
    int imageHeight;
    int imageWidth;
    static final int TEXT_INSET = 6;
    static final int BORDER = 1;
    static final int CHEVRON_SIZE = 24;

    public ExpandItem(ExpandBar expandBar, int n) {
        super(expandBar, n);
        this.parent = expandBar;
        this.createWidget(expandBar.getItemCount());
    }

    public ExpandItem(ExpandBar expandBar, int n, int n2) {
        super(expandBar, n);
        this.parent = expandBar;
        this.createWidget(n2);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        this.handle = OS.gtk_expander_new(null);
        if (this.handle == 0) {
            this.error(2);
        }
        this.clientHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.clientHandle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.handle, this.clientHandle);
        this.boxHandle = this.gtk_box_new(0, false, 4);
        if (this.boxHandle == 0) {
            this.error(2);
        }
        this.labelHandle = OS.gtk_label_new(null);
        if (this.labelHandle == 0) {
            this.error(2);
        }
        this.imageHandle = OS.gtk_image_new();
        if (this.imageHandle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.boxHandle, this.imageHandle);
        OS.gtk_container_add(this.boxHandle, this.labelHandle);
        OS.gtk_expander_set_label_widget(this.handle, this.boxHandle);
        OS.gtk_widget_set_can_focus(this.handle, true);
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.showWidget(n);
        this.parent.createItem(this, this.style, n);
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.clientHandle);
        this.display.removeWidget(this.boxHandle);
        this.display.removeWidget(this.labelHandle);
        this.display.removeWidget(this.imageHandle);
    }

    @Override
    void release(boolean bl) {
        if (OS.GTK3 && this.control != null && !this.control.isDisposed()) {
            this.control.release(bl);
        }
        super.release(bl);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        super.destroyWidget();
    }

    void drawChevron(GC gC, int n, int n2) {
        int[] nArray;
        int[] nArray2;
        if (this.expanded) {
            int n3 = n + 4 + 5;
            int n4 = n2 + 4 + 7;
            nArray2 = new int[]{n3, n4, n3 + 1, n4, n3 + 1, n4 - 1, n3 + 2, n4 - 1, n3 + 2, n4 - 2, n3 + 3, n4 - 2, n3 + 3, n4 - 3, n3 + 3, n4 - 2, n3 + 4, n4 - 2, n3 + 4, n4 - 1, n3 + 5, n4 - 1, n3 + 5, n4, n3 + 6, n4};
            nArray = new int[]{n3, n4 += 4, n3 + 1, n4, n3 + 1, n4 - 1, n3 + 2, n4 - 1, n3 + 2, n4 - 2, n3 + 3, n4 - 2, n3 + 3, n4 - 3, n3 + 3, n4 - 2, n3 + 4, n4 - 2, n3 + 4, n4 - 1, n3 + 5, n4 - 1, n3 + 5, n4, n3 + 6, n4};
        } else {
            int n5 = n + 4 + 5;
            int n6 = n2 + 4 + 4;
            nArray2 = new int[]{n5, n6, n5 + 1, n6, n5 + 1, n6 + 1, n5 + 2, n6 + 1, n5 + 2, n6 + 2, n5 + 3, n6 + 2, n5 + 3, n6 + 3, n5 + 3, n6 + 2, n5 + 4, n6 + 2, n5 + 4, n6 + 1, n5 + 5, n6 + 1, n5 + 5, n6, n5 + 6, n6};
            nArray = new int[]{n5, n6 += 4, n5 + 1, n6, n5 + 1, n6 + 1, n5 + 2, n6 + 1, n5 + 2, n6 + 2, n5 + 3, n6 + 2, n5 + 3, n6 + 3, n5 + 3, n6 + 2, n5 + 4, n6 + 2, n5 + 4, n6 + 1, n5 + 5, n6 + 1, n5 + 5, n6, n5 + 6, n6};
        }
        gC.setForeground(this.display.getSystemColor(30));
        gC.drawPolyline(DPIUtil.autoScaleDown(nArray2));
        gC.drawPolyline(DPIUtil.autoScaleDown(nArray));
    }

    void drawItem(GC gC, boolean bl) {
        int n = this.parent.getBandHeight();
        Display display = this.getDisplay();
        gC.setForeground(display.getSystemColor(31));
        gC.setBackground(display.getSystemColor(32));
        gC.fillGradientRectangle(this.x, this.y, this.width, n, true);
        if (this.expanded) {
            gC.setForeground(display.getSystemColor(32));
            gC.drawLine(this.x, this.y + n, this.x, this.y + n + this.height - 1);
            gC.drawLine(this.x, this.y + n + this.height - 1, this.x + this.width - 1, this.y + n + this.height - 1);
            gC.drawLine(this.x + this.width - 1, this.y + n + this.height - 1, this.x + this.width - 1, this.y + n);
        }
        int n2 = this.x;
        if (this.image != null) {
            n2 += 6;
            if (this.imageHeight > n) {
                gC.drawImage(this.image, n2, this.y + n - this.imageHeight);
            } else {
                gC.drawImage(this.image, n2, this.y + (n - this.imageHeight) / 2);
            }
            n2 += this.imageWidth;
        }
        if (this.text.length() > 0) {
            Point point = gC.stringExtent(this.text);
            gC.setForeground(this.parent.getForeground());
            gC.drawString(this.text, n2 += 6, this.y + (n - point.y) / 2, true);
        }
        int n3 = 24;
        this.drawChevron(gC, this.x + this.width - n3, this.y + (n - n3) / 2);
        if (bl) {
            gC.drawFocus(this.x + 1, this.y + 1, this.width - 2, n - 2);
        }
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getHeaderHeightInPixels());
    }

    int getHeaderHeightInPixels() {
        this.checkWidget();
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.handle, gtkAllocation);
        return gtkAllocation.height - (this.expanded ? this.height : 0);
    }

    public int getHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getHeightInPixels());
    }

    int getHeightInPixels() {
        this.checkWidget();
        return this.height;
    }

    public ExpandBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth(GC gC) {
        int n = 36;
        if (this.image != null) {
            n += 6 + this.imageWidth;
        }
        if (this.text.length() > 0) {
            n += gC.stringExtent((String)this.text).x;
        }
        return n;
    }

    @Override
    int gtk_activate(int n) {
        Event event = new Event();
        event.item = this;
        int n2 = OS.gtk_expander_get_expanded(this.handle) ? 18 : 17;
        this.parent.sendEvent(n2, event);
        return 0;
    }

    @Override
    int gtk_button_press_event(int n, int n2) {
        this.setFocus();
        return 0;
    }

    @Override
    int gtk_focus_out_event(int n, int n2) {
        OS.gtk_widget_set_can_focus(this.handle, false);
        this.parent.lastFocus = this;
        return 0;
    }

    @Override
    int gtk_size_allocate(int n, int n2) {
        this.parent.layoutItems(0, false);
        return 0;
    }

    @Override
    int gtk_enter_notify_event(int n, int n2) {
        this.parent.gtk_enter_notify_event(n, n2);
        return 0;
    }

    boolean hasFocus() {
        return OS.gtk_widget_has_focus(this.handle);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(60), true);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[22], 0, this.display.getClosure(22), false);
        OS.g_signal_connect_closure(this.clientHandle, OS.size_allocate, this.display.getClosure(47), true);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[14], 0, this.display.getClosure(14), false);
    }

    void redraw() {
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.clientHandle, this);
        this.display.addWidget(this.boxHandle, this);
        this.display.addWidget(this.labelHandle, this);
        this.display.addWidget(this.imageHandle, this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0;
        this.labelHandle = 0;
        this.boxHandle = 0;
        this.clientHandle = 0;
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (this.parent.lastFocus == this) {
            this.parent.lastFocus = null;
        }
        this.imageList = null;
        this.control = null;
    }

    void resizeControl(int n) {
        if (this.control != null && !this.control.isDisposed()) {
            boolean bl = OS.gtk_expander_get_expanded(this.handle);
            if (bl) {
                int n2;
                GtkAllocation gtkAllocation = new GtkAllocation();
                OS.gtk_widget_get_allocation(this.clientHandle, gtkAllocation);
                int n3 = OS.GTK3 ? 0 : gtkAllocation.x;
                int n4 = n2 = OS.GTK3 ? 0 : gtkAllocation.y;
                if (n3 != -1 && n2 != -1) {
                    int n5 = gtkAllocation.width;
                    int n6 = gtkAllocation.height;
                    int[] nArray = new int[1];
                    OS.gtk_widget_style_get(this.handle, OS.focus_line_width, nArray, 0);
                    n2 += nArray[0] * 2;
                    n6 -= nArray[0] * 2;
                    ScrollBar scrollBar = this.parent.verticalBar;
                    if (scrollBar != null && OS.gtk_widget_get_visible(scrollBar.handle)) {
                        OS.gtk_widget_get_allocation(this.parent.scrolledHandle, gtkAllocation);
                        n5 = gtkAllocation.width - this.parent.vScrollBarWidth() - 2 * this.parent.spacing;
                    }
                    this.control.setBounds(n3, n2 - n, n5, Math.max(0, n6), true, true);
                }
            }
            this.control.setVisible(bl);
        }
    }

    void setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.redraw();
        int n5 = this.parent.getBandHeight();
        if (bl) {
            if (this.imageHeight > n5) {
                n2 += this.imageHeight - n5;
            }
            this.x = n;
            this.y = n2;
            this.redraw();
        }
        if (bl2) {
            this.width = n3;
            this.height = n4;
            this.redraw();
        }
        if (this.control != null && !this.control.isDisposed()) {
            if (bl) {
                this.control.setLocationInPixels(n + 1, n2 + n5);
            }
            if (bl2) {
                this.control.setSizeInPixels(Math.max(0, n3 - 2), Math.max(0, n4 - 1));
            }
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        if (control != null) {
            control.setVisible(this.expanded);
            if (OS.GTK3) {
                this.gtk_widget_reparent(control.topHandle(), this.clientHandle());
            }
        }
        this.parent.layoutItems(0, true);
    }

    int clientHandle() {
        return this.clientHandle;
    }

    public void setExpanded(boolean bl) {
        this.checkWidget();
        this.expanded = bl;
        OS.gtk_expander_set_expanded(this.handle, bl);
        this.parent.layoutItems(0, true);
    }

    boolean setFocus() {
        if (!OS.gtk_widget_get_child_visible(this.handle)) {
            return false;
        }
        OS.gtk_widget_set_can_focus(this.handle, true);
        OS.gtk_widget_grab_focus(this.handle);
        if (this.isDisposed()) {
            return false;
        }
        boolean bl = OS.gtk_widget_is_focus(this.handle);
        if (!bl) {
            OS.gtk_widget_set_can_focus(this.handle, false);
        }
        return bl;
    }

    void setFontDescription(int n) {
        this.setFontDescription(this.handle, n);
        if (this.labelHandle != 0) {
            this.setFontDescription(this.labelHandle, n);
        }
        if (this.imageHandle != 0) {
            this.setFontDescription(this.imageHandle, n);
        }
    }

    void setForegroundColor(GdkColor gdkColor) {
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            GdkRGBA gdkRGBA = null;
            if (gdkColor != null) {
                gdkRGBA = this.display.toGdkRGBA(gdkColor);
            }
            this.parent.setForegroundColor(this.handle, gdkRGBA);
            if (this.labelHandle != 0) {
                this.parent.setForegroundColor(this.labelHandle, gdkRGBA);
            }
            if (this.imageHandle != 0) {
                this.parent.setForegroundColor(this.imageHandle, gdkRGBA);
            }
        } else {
            this.setForegroundColor(this.handle, gdkColor);
            if (this.labelHandle != 0) {
                this.setForegroundColor(this.labelHandle, gdkColor);
            }
            if (this.imageHandle != 0) {
                this.setForegroundColor(this.imageHandle, gdkColor);
            }
        }
    }

    public void setHeight(int n) {
        this.checkWidget();
        this.setHeightInPixels(DPIUtil.autoScaleUp(n));
    }

    void setHeightInPixels(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.height = n;
        OS.gtk_widget_set_size_request(this.clientHandle, -1, n);
        this.parent.layoutItems(0, false);
    }

    @Override
    public void setImage(Image image) {
        super.setImage(image);
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            this.imageList = new ImageList();
            int n = this.imageList.add(image);
            int n2 = this.imageList.getPixbuf(n);
            this.gtk_image_set_from_pixbuf(this.imageHandle, n2);
            if (this.text.length() == 0) {
                OS.gtk_widget_hide(this.labelHandle);
            }
            OS.gtk_widget_show(this.imageHandle);
        } else {
            this.gtk_image_set_from_pixbuf(this.imageHandle, 0);
            OS.gtk_widget_show(this.labelHandle);
            OS.gtk_widget_hide(this.imageHandle);
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.parent.style & 0x4000000) != 0 || !bl) {
            int n = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            OS.gtk_widget_set_direction(this.handle, n);
            OS.gtk_container_forall(this.handle, this.display.setDirectionProc, n);
        }
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        OS.gtk_label_set_text(this.labelHandle, byArray);
    }

    void showWidget(int n) {
        OS.gtk_widget_show(this.handle);
        OS.gtk_widget_show(this.clientHandle);
        if (this.labelHandle != 0) {
            OS.gtk_widget_show(this.labelHandle);
        }
        if (this.boxHandle != 0) {
            OS.gtk_widget_show(this.boxHandle);
        }
        OS.gtk_container_add(this.parent.handle, this.handle);
        OS.gtk_box_set_child_packing(this.parent.handle, this.handle, false, false, 0, 0);
    }

    @Override
    int windowProc(int n, int n2) {
        switch (n2) {
            case 60: {
                this.expanded = OS.gtk_expander_get_expanded(n);
                this.parent.layoutItems(0, false);
                return 0;
            }
        }
        return super.windowProc(n, n2);
    }
}

