/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve;

import com.jogamp.graph.geom.Triangle;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.ArrayList;
import jogamp.opengl.Debug;

public abstract class Region {
    public static final boolean DEBUG = Debug.debug("graph.curve");
    public static final boolean DEBUG_INSTANCE = false;
    public static final int VBAA_RENDERING_BIT = 1;
    public static final int VARIABLE_CURVE_WEIGHT_BIT = 2;
    public static final int TWO_PASS_DEFAULT_TEXTURE_UNIT = 0;
    private final int renderModes;
    private boolean dirty = true;
    protected int numVertices = 0;
    protected final AABBox box = new AABBox();
    protected ArrayList<Triangle> triangles = new ArrayList();
    protected ArrayList<Vertex> vertices = new ArrayList();

    public static boolean isVBAA(int n) {
        return 0 != (n & 1);
    }

    public static boolean isNonUniformWeight(int n) {
        return 0 != (n & 2);
    }

    protected Region(int n) {
        this.renderModes = n;
    }

    public final int getRenderModes() {
        return this.renderModes;
    }

    public boolean isVBAA() {
        return Region.isVBAA(this.renderModes);
    }

    public boolean isNonUniformWeight() {
        return Region.isNonUniformWeight(this.renderModes);
    }

    public final int getNumVertices() {
        return this.numVertices;
    }

    public void addTriangle(Triangle triangle) {
        this.triangles.add(triangle);
        this.setDirty(true);
    }

    public void addTriangles(ArrayList<Triangle> arrayList) {
        this.triangles.addAll(arrayList);
        this.setDirty(true);
    }

    public void addVertex(Vertex vertex) {
        this.vertices.add(vertex);
        ++this.numVertices;
        this.setDirty(true);
    }

    public void addVertices(ArrayList<Vertex> arrayList) {
        this.vertices.addAll(arrayList);
        this.numVertices = this.vertices.size();
        this.setDirty(true);
    }

    public final AABBox getBounds() {
        return this.box;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    protected final void setDirty(boolean bl) {
        this.dirty = bl;
    }
}

