#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hackage-security
version: 0.5.2.1
id: hackage-security-0.5.2.1-21lvx7ErxOs1hxoYS9UP85
key: hackage-security-0.5.2.1-21lvx7ErxOs1hxoYS9UP85
license: BSD3
copyright: Copyright 2015-2016 Well-Typed LLP
maintainer: edsko@well-typed.com
homepage: https://github.com/well-typed/hackage-security
synopsis: Hackage security library
description:
    The hackage security library provides both server and
    client utilities for securing the Hackage package server
    (<http://hackage.haskell.org/>).  It is based on The Update
    Framework (<http://theupdateframework.com/>), a set of
    recommendations developed by security researchers at
    various universities in the US as well as developers on the
    Tor project (<https://www.torproject.org/>).
    .
    The current implementation supports only index signing,
    thereby enabling untrusted mirrors. It does not yet provide
    facilities for author package signing.
    .
    The library has two main entry points:
    "Hackage.Security.Client" is the main entry point for
    clients (the typical example being @cabal@), and
    "Hackage.Security.Server" is the main entry point for
    servers (the typical example being @hackage-server@).
category: Distribution
author: Edsko de Vries
exposed: True
exposed-modules:
    Hackage.Security.Client Hackage.Security.Client.Formats
    Hackage.Security.Client.Repository
    Hackage.Security.Client.Repository.Cache
    Hackage.Security.Client.Repository.Local
    Hackage.Security.Client.Repository.Remote
    Hackage.Security.Client.Repository.HttpLib
    Hackage.Security.Client.Verify Hackage.Security.JSON
    Hackage.Security.Key.Env Hackage.Security.Server
    Hackage.Security.Trusted Hackage.Security.TUF.FileMap
    Hackage.Security.Util.Checked Hackage.Security.Util.IO
    Hackage.Security.Util.Lens Hackage.Security.Util.Path
    Hackage.Security.Util.Pretty Hackage.Security.Util.Some
    Text.JSON.Canonical
hidden-modules: Hackage.Security.Key Hackage.Security.Trusted.TCB
                Hackage.Security.TUF Hackage.Security.TUF.Common
                Hackage.Security.TUF.FileInfo Hackage.Security.TUF.Header
                Hackage.Security.TUF.Layout.Cache Hackage.Security.TUF.Layout.Index
                Hackage.Security.TUF.Layout.Repo Hackage.Security.TUF.Mirrors
                Hackage.Security.TUF.Paths Hackage.Security.TUF.Patterns
                Hackage.Security.TUF.Root Hackage.Security.TUF.Signed
                Hackage.Security.TUF.Snapshot Hackage.Security.TUF.Targets
                Hackage.Security.TUF.Timestamp Hackage.Security.Util.Base64
                Hackage.Security.Util.JSON Hackage.Security.Util.Stack
                Hackage.Security.Util.TypedEmbedded Prelude
abi: bee0019d96738552309ef880152ce3ba
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/hackage-security-0.5.2.1
library-dirs: /usr/lib/ghc-8.0.1/site-local/hackage-security-0.5.2.1
data-dir: /usr/share/arm-linux-ghc-8.0.1/hackage-security-0.5.2.1
hs-libraries: HShackage-security-0.5.2.1-21lvx7ErxOs1hxoYS9UP85
depends:
    Cabal-1.24.0.0 base-4.9.0.0
    base16-bytestring-0.1.1.6-5dPoF8dzhwzBaEB2MvnmIS
    base64-bytestring-1.0.0.1-In9M41tLtcS9QYt3QpGpNY
    bytestring-0.10.8.1 containers-0.5.7.1
    cryptohash-sha256-0.11.100.1-CxymMT87vhE9zOHmyydW84
    directory-1.2.6.2 ed25519-0.0.5.0-5iyOz6h7sMK6kf56f6qgHl
    filepath-1.4.1.0 ghc-prim-0.5.0.0 mtl-2.2.1-6qsR1PHUy5lL47Hpoa4jCM
    network-2.6.3.1-G4Up1CPKbp7DeFsnywOnGG
    network-uri-2.6.1.0-8yR4gjnzE4eDGhJR7PHfVJ
    parsec-3.1.11-IYEP8Lv1S9x5FeUQxGPDBY pretty-1.1.3.3
    tar-0.5.0.3-Lj53UbIqLpELgGWYmsAfKo template-haskell-2.11.0.0
    time-1.6.0.1 transformers-0.5.2.0
    zlib-0.6.1.1-IKN2DpYEe8r3bYFvs7BDUW
haddock-interfaces: /usr/share/doc/haskell-hackage-security/html/hackage-security.haddock
haddock-html: /usr/share/doc/haskell-hackage-security/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
