/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;

public class LayerTransferable
implements Transferable {
    public static final DataFlavor LAYER_DATA = new DataFlavor("application/x-java-jvm-local-objectref;class=" + Data.class.getName(), "Layers");
    private final Data data;

    public LayerTransferable(LayerManager layerManager, List<Layer> list) {
        this.data = new Data(layerManager, list);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{LAYER_DATA};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return LAYER_DATA.equals(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return this.data;
    }

    public static class Data {
        private final LayerManager manager;
        private final List<Layer> layers;

        public Data(LayerManager layerManager, List<Layer> list) {
            this.manager = layerManager;
            this.layers = new ArrayList<Layer>(list);
        }

        public LayerManager getManager() {
            return this.manager;
        }

        public List<Layer> getLayers() {
            return Collections.unmodifiableList(this.layers);
        }

        public String toString() {
            return "Data [layers=" + this.layers + ']';
        }
    }
}

