/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.Signature;
import com.headius.invokebinder.SmartBinder;
import com.headius.invokebinder.SmartHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.SwitchPoint;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubySymbol;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.ir.JIT;
import org.jruby.ir.targets.Bootstrap;
import org.jruby.ir.targets.SelfInvokeSite;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.invokedynamic.JRubyCallSite;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public abstract class InvokeSite
extends MutableCallSite {
    final Signature signature;
    final Signature fullSignature;
    final int arity;
    protected final String methodName;
    final MethodHandle fallback;
    private final Set<Integer> seenTypes = new HashSet<Integer>();
    private int clearCount;
    private static final AtomicLong SITE_ID = new AtomicLong(1L);
    private final long siteID = SITE_ID.getAndIncrement();
    private final int argOffset;
    private boolean boundOnce;
    CacheEntry cache = CacheEntry.NULL_CACHE;
    private static final Logger LOG = LoggerFactory.getLogger(InvokeSite.class);
    public final CallType callType;
    private static final MethodHandle TEST_CLASS = Binder.from(Boolean.TYPE, Object.class, Class.class).invokeStaticQuiet(MethodHandles.lookup(), InvokeSite.class, "testClass");

    public String name() {
        return this.methodName;
    }

    public InvokeSite(MethodType type2, String name2, CallType callType) {
        super(type2);
        int arity2;
        Signature startSig;
        this.methodName = name2;
        this.callType = callType;
        if (callType == CallType.SUPER) {
            startSig = JRubyCallSite.STANDARD_SUPER_SIG;
            this.argOffset = 4;
        } else {
            startSig = JRubyCallSite.STANDARD_SITE_SIG;
            this.argOffset = 3;
        }
        if (type2.parameterType(type2.parameterCount() - 1) == Block.class) {
            arity2 = type2.parameterCount() - (this.argOffset + 1);
            if (arity2 == 1 && type2.parameterType(this.argOffset) == IRubyObject[].class) {
                arity2 = -1;
                startSig = startSig.appendArg("args", IRubyObject[].class);
            } else {
                for (int i2 = 0; i2 < arity2; ++i2) {
                    startSig = startSig.appendArg("arg" + i2, IRubyObject.class);
                }
            }
            this.fullSignature = this.signature = (startSig = startSig.appendArg("block", Block.class));
        } else {
            arity2 = type2.parameterCount() - this.argOffset;
            if (arity2 == 1 && type2.parameterType(this.argOffset) == IRubyObject[].class) {
                arity2 = -1;
                startSig = startSig.appendArg("args", IRubyObject[].class);
            } else {
                for (int i3 = 0; i3 < arity2; ++i3) {
                    startSig = startSig.appendArg("arg" + i3, IRubyObject.class);
                }
            }
            this.signature = startSig;
            this.fullSignature = startSig.appendArg("block", Block.class);
        }
        this.arity = arity2;
        this.fallback = this.prepareBinder().invokeVirtualQuiet(Bootstrap.LOOKUP, "invoke");
    }

    public static CallSite bootstrap(InvokeSite site, MethodHandles.Lookup lookup) {
        site.setInitialTarget(site.fallback);
        return site;
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2, Block block) throws Throwable {
        RubyClass selfClass = this.pollAndGetClass(context, self2);
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(this.methodName);
        DynamicMethod method = entry.method;
        if (this.methodMissing(entry, caller)) {
            return this.callMethodMissing(entry, this.callType, context, self2, this.methodName, args2, block);
        }
        MethodHandle mh = this.getHandle(self2, selfClass, method);
        this.updateInvocationTarget(mh, self2, selfClass, entry.method, switchPoint);
        return method.call(context, self2, (RubyModule)selfClass, this.methodName, args2, block);
    }

    public IRubyObject fail(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2, Block block) throws Throwable {
        RubyClass selfClass = this.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, (RubyModule)selfClass, name2, args2, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry, caller)) {
            return this.callMethodMissing(entry, this.callType, context, self2, name2, args2, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, (RubyModule)selfClass, name2, args2, block);
    }

    public Binder prepareBinder() {
        SmartBinder binder = SmartBinder.from(this.signature);
        if (this.arity != -1) {
            binder = this.arity == 0 ? binder.insert(this.argOffset, "args", IRubyObject.NULL_ARRAY) : binder.collect("args", "arg[0-9]+");
        }
        if (this.signature.lastArgType() != Block.class) {
            binder = binder.append("block", Block.NULL_BLOCK);
        }
        binder = binder.insert(0, "site", this);
        return binder.binder();
    }

    MethodHandle getHandle(IRubyObject self2, RubyClass dispatchClass, DynamicMethod method) throws Throwable {
        boolean blockGiven = this.signature.lastArgType() == Block.class;
        MethodHandle mh = this.buildNewInstanceHandle(method, self2, blockGiven);
        if (mh == null) {
            mh = Bootstrap.buildNativeHandle(this, method, blockGiven);
        }
        if (mh == null) {
            mh = Bootstrap.buildIndyHandle(this, method, method.getImplementationClass());
        }
        if (mh == null) {
            mh = Bootstrap.buildJittedHandle(this, method, blockGiven);
        }
        if (mh == null) {
            mh = Bootstrap.buildAttrHandle(this, method, self2, dispatchClass);
        }
        if (mh == null) {
            mh = Bootstrap.buildGenericHandle(this, method, dispatchClass);
        }
        assert (mh != null) : "we should have a method handle of some sort by now";
        return mh;
    }

    MethodHandle buildNewInstanceHandle(DynamicMethod method, IRubyObject self2, boolean blockGiven) {
        MethodHandle mh = null;
        if (method == self2.getRuntime().getBaseNewMethod()) {
            RubyClass recvClass = (RubyClass)self2;
            CallSite initSite = SelfInvokeSite.bootstrap(MethodHandles.lookup(), "callFunctional:initialize", this.type());
            MethodHandle initHandle = initSite.dynamicInvoker();
            MethodHandle allocFilter = Binder.from(IRubyObject.class, IRubyObject.class, new Class[0]).cast(IRubyObject.class, RubyClass.class).insert(0, new Class[]{ObjectAllocator.class, Ruby.class}, new Object[]{recvClass.getAllocator(), self2.getRuntime()}).invokeVirtualQuiet(MethodHandles.lookup(), "allocate");
            mh = SmartBinder.from(MethodHandles.lookup(), this.signature).filter("self", allocFilter).fold("dummy", initHandle).permute("self").identity().handle();
        }
        return mh;
    }

    MethodHandle updateInvocationTarget(MethodHandle target, IRubyObject self2, RubyModule testClass, DynamicMethod method, SwitchPoint switchPoint) {
        if (target == null || this.clearCount > Options.INVOKEDYNAMIC_MAXFAIL.load() || !this.hasSeenType(testClass.id) && this.seenTypesCount() + 1 > Options.INVOKEDYNAMIC_MAXPOLY.load()) {
            target = this.prepareBinder().invokeVirtualQuiet(MethodHandles.lookup(), "fail");
            this.setTarget(target);
        } else {
            MethodHandle fallback;
            if (this.seenTypesCount() > 0 && this.getTarget() != null && !this.hasSeenType(testClass.id)) {
                if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                    LOG.info(this.methodName + "\tadded to PIC " + InvokeSite.logMethod(method), new Object[0]);
                }
                fallback = this.getTarget();
            } else {
                String bind2;
                String string2 = bind2 = this.boundOnce ? "rebind" : "bind";
                if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                    LOG.info(this.methodName + "\ttriggered site #" + this.siteID + " " + bind2, new Object[0]);
                }
                fallback = this.fallback;
                this.clearTypes();
            }
            this.addType(testClass.id);
            SmartBinder selfTest = SmartBinder.from(this.signature.asFold(Boolean.TYPE)).permute("self");
            SmartHandle test2 = self2 instanceof RubySymbol || self2 instanceof RubyFixnum || self2 instanceof RubyFloat || self2 instanceof RubyNil || self2 instanceof RubyBoolean.True || self2 instanceof RubyBoolean.False ? selfTest.insert(1, "selfJavaType", self2.getClass()).cast(Boolean.TYPE, Object.class, Class.class).invoke(TEST_CLASS) : SmartBinder.from(this.signature.changeReturn(Boolean.TYPE)).permute("self").insert(0, "selfClass", RubyClass.class, (Object)testClass).invokeStaticQuiet(Bootstrap.LOOKUP, Bootstrap.class, "testType");
            MethodHandle gwt = MethodHandles.guardWithTest(test2.handle(), target, fallback);
            gwt = switchPoint.guardWithTest(gwt, fallback);
            this.setTarget(gwt);
        }
        return target;
    }

    public RubyClass pollAndGetClass(ThreadContext context, IRubyObject self2) {
        context.callThreadPoll();
        RubyClass selfType = ((RubyBasicObject)self2).getMetaClass();
        return selfType;
    }

    @Override
    public void setTarget(MethodHandle target) {
        super.setTarget(target);
        this.boundOnce = true;
    }

    public void setInitialTarget(MethodHandle target) {
        super.setTarget(target);
    }

    public synchronized boolean hasSeenType(int typeCode) {
        return this.seenTypes.contains(typeCode);
    }

    public synchronized void addType(int typeCode) {
        this.seenTypes.add(typeCode);
    }

    public synchronized int seenTypesCount() {
        return this.seenTypes.size();
    }

    public synchronized void clearTypes() {
        this.seenTypes.clear();
        ++this.clearCount;
    }

    public abstract boolean methodMissing(CacheEntry var1, IRubyObject var2);

    public IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        return Helpers.selectMethodMissing(context, self2, entry.method.getVisibility(), name2, callType).call(context, self2, (RubyModule)self2.getMetaClass(), name2, args2, block);
    }

    private static String logMethod(DynamicMethod method) {
        return "[#" + method.getSerialNumber() + " " + method.getImplementationClass() + "]";
    }

    @JIT
    public static boolean testMetaclass(RubyClass metaclass, IRubyObject self2) {
        return metaclass == ((RubyBasicObject)self2).getMetaClass();
    }

    @JIT
    public static boolean testClass(Object object, Class clazz) {
        return object.getClass() == clazz;
    }
}

