/*
 * irq.h
 *
 * Copyright (c) 2012 Samsung Electronics Co., Ltd
 *              http://www.samsung.com
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 */

#ifndef __LINUX_MFD_SEC_IRQ_H
#define __LINUX_MFD_SEC_IRQ_H

enum s2mps11_irq {
	S2MPS11_IRQ_PWRONF,
	S2MPS11_IRQ_PWRONR,
	S2MPS11_IRQ_JIGONBF,
	S2MPS11_IRQ_JIGONBR,
	S2MPS11_IRQ_ACOKBF,
	S2MPS11_IRQ_ACOKBR,
	S2MPS11_IRQ_PWRON1S,
	S2MPS11_IRQ_MRB,

	S2MPS11_IRQ_RTC60S,
	S2MPS11_IRQ_RTCA2,
	S2MPS11_IRQ_RTCA1,
	S2MPS11_IRQ_SMPL,
	S2MPS11_IRQ_RTC1S,
	S2MPS11_IRQ_WTSR,

	S2MPS11_IRQ_INT120C,
	S2MPS11_IRQ_INT140C,

	S2MPS11_IRQ_NR,
};

#define S2MPS11_IRQ_PWRONF_MASK		(1 << 0)
#define S2MPS11_IRQ_PWRONR_MASK		(1 << 1)
#define S2MPS11_IRQ_JIGONBF_MASK	(1 << 2)
#define S2MPS11_IRQ_JIGONBR_MASK	(1 << 3)
#define S2MPS11_IRQ_ACOKBF_MASK		(1 << 4)
#define S2MPS11_IRQ_ACOKBR_MASK		(1 << 5)
#define S2MPS11_IRQ_PWRON1S_MASK	(1 << 6)
#define S2MPS11_IRQ_MRB_MASK		(1 << 7)

#define S2MPS11_IRQ_RTC60S_MASK		(1 << 0)
#define S2MPS11_IRQ_RTCA2_MASK		(1 << 1)
#define S2MPS11_IRQ_RTCA1_MASK		(1 << 2)
#define S2MPS11_IRQ_SMPL_MASK		(1 << 3)
#define S2MPS11_IRQ_RTC1S_MASK		(1 << 4)
#define S2MPS11_IRQ_WTSR_MASK		(1 << 5)

#define S2MPS11_IRQ_INT120C_MASK	(1 << 0)
#define S2MPS11_IRQ_INT140C_MASK	(1 << 1)

enum s5m8767_irq {
	S5M8767_IRQ_PWRR,
	S5M8767_IRQ_PWRF,
	S5M8767_IRQ_PWR1S,
	S5M8767_IRQ_JIGR,
	S5M8767_IRQ_JIGF,
	S5M8767_IRQ_LOWBAT2,
	S5M8767_IRQ_LOWBAT1,

	S5M8767_IRQ_MRB,
	S5M8767_IRQ_DVSOK2,
	S5M8767_IRQ_DVSOK3,
	S5M8767_IRQ_DVSOK4,

	S5M8767_IRQ_RTC60S,
	S5M8767_IRQ_RTCA1,
	S5M8767_IRQ_RTCA2,
	S5M8767_IRQ_SMPL,
	S5M8767_IRQ_RTC1S,
	S5M8767_IRQ_WTSR,

	S5M8767_IRQ_NR,
};

#define S5M8767_IRQ_PWRR_MASK		(1 << 0)
#define S5M8767_IRQ_PWRF_MASK		(1 << 1)
#define S5M8767_IRQ_PWR1S_MASK		(1 << 3)
#define S5M8767_IRQ_JIGR_MASK		(1 << 4)
#define S5M8767_IRQ_JIGF_MASK		(1 << 5)
#define S5M8767_IRQ_LOWBAT2_MASK	(1 << 6)
#define S5M8767_IRQ_LOWBAT1_MASK	(1 << 7)

#define S5M8767_IRQ_MRB_MASK		(1 << 2)
#define S5M8767_IRQ_DVSOK2_MASK		(1 << 3)
#define S5M8767_IRQ_DVSOK3_MASK		(1 << 4)
#define S5M8767_IRQ_DVSOK4_MASK		(1 << 5)

#define S5M8767_IRQ_RTC60S_MASK		(1 << 0)
#define S5M8767_IRQ_RTCA1_MASK		(1 << 1)
#define S5M8767_IRQ_RTCA2_MASK		(1 << 2)
#define S5M8767_IRQ_SMPL_MASK		(1 << 3)
#define S5M8767_IRQ_RTC1S_MASK		(1 << 4)
#define S5M8767_IRQ_WTSR_MASK		(1 << 5)

#endif /*  __LINUX_MFD_SEC_IRQ_H */
