/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import com.google.dart.compiler.util.AstUtil;
import org.jetbrains.annotations.NotNull;

public class JsFor
extends SourceInfoAwareJsNode
implements JsStatement {
    private JsStatement body;
    private JsExpression condition;
    private JsExpression incrementExpression;
    private JsExpression initExpression;
    private JsVars initVars;

    public JsFor(JsVars initVars, JsExpression condition, JsExpression incrementExpression) {
        this(initVars, condition, incrementExpression, null);
    }

    public JsFor(JsVars initVars, JsExpression condition, JsExpression incrementExpression, JsStatement body) {
        this.initVars = initVars;
        this.incrementExpression = incrementExpression;
        this.condition = condition;
        this.body = body;
        this.initExpression = null;
    }

    public JsFor(JsExpression initExpression, JsExpression condition, JsExpression incrementExpression) {
        this(initExpression, condition, incrementExpression, null);
    }

    public JsFor(JsExpression initExpression, JsExpression condition, JsExpression incrementExpression, JsStatement body) {
        this.initExpression = initExpression;
        this.incrementExpression = incrementExpression;
        this.condition = condition;
        this.body = body;
        this.initVars = null;
    }

    public JsStatement getBody() {
        return this.body;
    }

    public JsExpression getCondition() {
        return this.condition;
    }

    public JsExpression getIncrementExpression() {
        return this.incrementExpression;
    }

    public JsExpression getInitExpression() {
        return this.initExpression;
    }

    public JsVars getInitVars() {
        return this.initVars;
    }

    public void setBody(JsStatement body) {
        this.body = body;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitFor(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        assert (this.initExpression == null || this.initVars == null);
        if (this.initExpression != null) {
            visitor2.accept(this.initExpression);
        } else if (this.initVars != null) {
            visitor2.accept(this.initVars);
        }
        if (this.condition != null) {
            visitor2.accept(this.condition);
        }
        if (this.incrementExpression != null) {
            visitor2.accept(this.incrementExpression);
        }
        visitor2.accept(this.body);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            assert (this.initExpression == null || this.initVars == null);
            if (this.initExpression != null) {
                this.initExpression = v.accept(this.initExpression);
            } else if (this.initVars != null) {
                this.initVars = v.acceptStatement(this.initVars);
            }
            if (this.condition != null) {
                this.condition = v.accept(this.condition);
            }
            if (this.incrementExpression != null) {
                this.incrementExpression = v.accept(this.incrementExpression);
            }
            this.body = v.acceptStatement(this.body);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsFor deepCopy() {
        JsStatement bodyCopy = AstUtil.deepCopy(this.body);
        JsExpression conditionCopy = AstUtil.deepCopy(this.condition);
        JsExpression incrementalExprCopy = AstUtil.deepCopy(this.incrementExpression);
        JsFor result2 = this.initVars != null ? new JsFor(this.initVars.deepCopy(), conditionCopy, incrementalExprCopy, bodyCopy) : new JsFor(this.initExpression.deepCopy(), conditionCopy, this.incrementExpression, bodyCopy);
        JsFor jsFor = result2.withMetadataFrom(this);
        if (jsFor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsFor", "deepCopy"));
        }
        return jsFor;
    }
}

