/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInferenceHelper;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.PsiOldInferenceHelper;
import com.intellij.psi.impl.source.resolve.ResolveClassUtil;
import com.intellij.psi.impl.source.resolve.ResolveVariableUtil;
import com.intellij.psi.impl.source.resolve.graphInference.PsiGraphInferenceHelper;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiResolveHelperImpl
implements PsiResolveHelper {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.PsiResolveHelperImpl");
    private final PsiManager myManager;

    public PsiResolveHelperImpl(PsiManager manager) {
        this.myManager = manager;
    }

    @Override
    @NotNull
    public JavaResolveResult resolveConstructor(PsiClassType classType, @NotNull PsiExpressionList argumentList2, PsiElement place) {
        if (argumentList2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveConstructor"));
        }
        JavaResolveResult[] result2 = this.multiResolveConstructor(classType, argumentList2, place);
        JavaResolveResult javaResolveResult = result2.length == 1 ? result2[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveConstructor"));
        }
        return javaResolveResult;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolveConstructor(@NotNull PsiClassType type2, @NotNull PsiExpressionList argumentList2, @NotNull PsiElement place) {
        MethodResolverProcessor processor;
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
        }
        if (argumentList2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
        }
        PsiClassType.ClassResolveResult classResolveResult = type2.resolveGenerics();
        PsiClass aClass2 = classResolveResult.getElement();
        if (aClass2 == null) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiSubstitutor substitutor2 = classResolveResult.getSubstitutor();
        if (argumentList2.getParent() instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymous = (PsiAnonymousClass)argumentList2.getParent();
            processor = new MethodResolverProcessor(anonymous, argumentList2, place, place.getContainingFile());
            aClass2 = anonymous.getBaseClassType().resolve();
            if (aClass2 == null) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
        } else {
            processor = new MethodResolverProcessor(aClass2, argumentList2, place, place.getContainingFile());
        }
        ResolveState state2 = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor2);
        for (PsiMethod constructor : aClass2.getConstructors()) {
            if (!processor.execute(constructor, state2)) break;
        }
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiClass resolveReferencedClass(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveReferencedClass"));
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context);
            PsiFile containingFile = ref.getContainingFile();
            LOG.assertTrue(containingFile.isValid(), referenceText);
            return ResolveClassUtil.resolveClass(ref, containingFile);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public PsiVariable resolveReferencedVariable(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveReferencedVariable"));
        }
        return this.resolveVar(referenceText, context, null);
    }

    @Override
    public PsiVariable resolveAccessibleReferencedVariable(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveAccessibleReferencedVariable"));
        }
        boolean[] problemWithAccess = new boolean[1];
        PsiVariable variable = this.resolveVar(referenceText, context, problemWithAccess);
        return problemWithAccess[0] ? null : variable;
    }

    @Nullable
    private PsiVariable resolveVar(@NotNull String referenceText, PsiElement context, boolean[] problemWithAccess) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveVar"));
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context);
            return ResolveVariableUtil.resolveVariable(ref, problemWithAccess, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public boolean isAccessible(@NotNull PsiMember member, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "isAccessible"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "isAccessible"));
        }
        return this.isAccessible(member, member.getModifierList(), place, accessObjectClass, null);
    }

    @Override
    public boolean isAccessible(@NotNull PsiMember member, @Nullable PsiModifierList modifierList, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass, @Nullable PsiElement currentFileResolveScope) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "isAccessible"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "isAccessible"));
        }
        PsiClass containingClass = member.getContainingClass();
        return JavaResolveUtil.isAccessible(member, containingClass, modifierList, place, accessObjectClass, currentFileResolveScope);
    }

    @Override
    @NotNull
    public CandidateInfo[] getReferencedMethodCandidates(@NotNull PsiCallExpression expr, boolean dummyImplicitConstructor, final boolean checkVarargs) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
        }
        PsiFile containingFile = expr.getContainingFile();
        MethodCandidatesProcessor processor = new MethodCandidatesProcessor(expr, containingFile){

            @Override
            protected boolean acceptVarargs() {
                return checkVarargs;
            }
        };
        try {
            PsiScopesUtil.setupAndRunProcessor(processor, expr, dummyImplicitConstructor);
        }
        catch (MethodProcessorSetupFailedException e) {
            if (CandidateInfo.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
            }
            return CandidateInfo.EMPTY_ARRAY;
        }
        CandidateInfo[] candidateInfoArray = processor.getCandidates();
        if (candidateInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
        }
        return candidateInfoArray;
    }

    @Override
    @NotNull
    public CandidateInfo[] getReferencedMethodCandidates(@NotNull PsiCallExpression call, boolean dummyImplicitConstructor) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
        }
        CandidateInfo[] candidateInfoArray = this.getReferencedMethodCandidates(call, dummyImplicitConstructor, false);
        if (candidateInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
        }
        return candidateInfoArray;
    }

    @Override
    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @Nullable PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        return this.getInferenceHelper(PsiUtil.getLanguageLevel(parent2 != null ? parent2 : typeParameter)).inferTypeForMethodTypeParameter(typeParameter, parameters2, arguments2, partialSubstitutor, parent2, policy);
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(PsiUtil.getLanguageLevel(parent2)).inferTypeArguments(typeParameters, parameters2, arguments2, partialSubstitutor, parent2, policy, PsiUtil.getLanguageLevel(parent2));
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(languageLevel).inferTypeArguments(typeParameters, parameters2, arguments2, partialSubstitutor, parent2, policy, languageLevel);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiType[] leftTypes, @NotNull PsiType[] rightTypes, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (leftTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftTypes", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (rightTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightTypes", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(languageLevel).inferTypeArguments(typeParameters, leftTypes, rightTypes, languageLevel);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @Override
    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        return this.getInferenceHelper(languageLevel).getSubstitutionForTypeParameter(typeParam, param, arg, isContraVariantPosition, languageLevel);
    }

    @Override
    @NotNull
    public LanguageLevel getEffectiveLanguageLevel(@Nullable VirtualFile virtualFile) {
        LanguageLevel languageLevel = JavaPsiImplementationHelper.getInstance(this.myManager.getProject()).getEffectiveLanguageLevel(virtualFile);
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getEffectiveLanguageLevel"));
        }
        return languageLevel;
    }

    @NotNull
    public PsiInferenceHelper getInferenceHelper(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getInferenceHelper"));
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            PsiGraphInferenceHelper psiGraphInferenceHelper = new PsiGraphInferenceHelper(this.myManager);
            if (psiGraphInferenceHelper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getInferenceHelper"));
            }
            return psiGraphInferenceHelper;
        }
        PsiOldInferenceHelper psiOldInferenceHelper = new PsiOldInferenceHelper(this.myManager);
        if (psiOldInferenceHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getInferenceHelper"));
        }
        return psiOldInferenceHelper;
    }
}

