/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightDeclaration;
import org.jetbrains.kotlin.asJava.KtLightIdentifier;
import org.jetbrains.kotlin.asJava.KtLightMethod;
import org.jetbrains.kotlin.asJava.KtLightModifierListWithExplicitModifiers;
import org.jetbrains.kotlin.asJava.LightMemberOriginForDeclaration;
import org.jetbrains.kotlin.asJava.LightParameter;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

public class KtLightParameter
extends LightParameter
implements KtLightDeclaration<KtParameter, PsiParameter> {
    private final PsiModifierList modifierList;
    private final PsiParameter delegate;
    private final int index;
    private final KtLightMethod method;
    private KtLightIdentifier lightIdentifier = null;

    private static String getName(PsiParameter delegate2, int index2) {
        String name = delegate2.getName();
        return name != null ? name : "p" + index2;
    }

    public KtLightParameter(final PsiParameter delegate2, int index2, KtLightMethod method) {
        super(KtLightParameter.getName(delegate2, index2), delegate2.getType(), method, (Language)KotlinLanguage.INSTANCE);
        this.delegate = delegate2;
        this.index = index2;
        this.method = method;
        this.modifierList = method.getLightMethodOrigin() instanceof LightMemberOriginForDeclaration ? new KtLightModifierListWithExplicitModifiers(this, ArrayUtil.EMPTY_STRING_ARRAY){

            @Override
            public PsiAnnotationOwner getDelegate() {
                return delegate2.getModifierList();
            }
        } : super.getModifierList();
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = this.modifierList;
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtLightParameter", "getModifierList"));
        }
        return psiModifierList;
    }

    @Override
    @NotNull
    public PsiParameter getClsDelegate() {
        PsiParameter psiParameter = this.delegate;
        if (psiParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtLightParameter", "getClsDelegate"));
        }
        return psiParameter;
    }

    @Override
    @Nullable
    public KtParameter getKotlinOrigin() {
        int jetIndex;
        KtDeclaration declaration = (KtDeclaration)this.method.getKotlinOrigin();
        if (declaration == null) {
            return null;
        }
        int n = jetIndex = KtPsiUtilKt.isExtensionDeclaration(declaration) ? this.index - 1 : this.index;
        if (jetIndex < 0) {
            return null;
        }
        if (declaration instanceof KtFunction) {
            List<KtParameter> paramList = ((KtFunction)declaration).getValueParameters();
            return jetIndex < paramList.size() ? paramList.get(jetIndex) : null;
        }
        if (jetIndex != 0) {
            return null;
        }
        KtPropertyAccessor setter = null;
        if (declaration instanceof KtPropertyAccessor) {
            KtPropertyAccessor accessor = (KtPropertyAccessor)declaration;
            setter = accessor.isSetter() ? accessor : null;
        } else if (declaration instanceof KtProperty) {
            setter = ((KtProperty)declaration).getSetter();
        } else if (declaration instanceof KtParameter) {
            return (KtParameter)declaration;
        }
        return setter != null ? setter.getParameter() : null;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        KtParameter origin = this.getKotlinOrigin();
        PsiElement psiElement = origin != null ? origin : super.getNavigationElement();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtLightParameter", "getNavigationElement"));
        }
        return psiElement;
    }

    @Override
    public boolean isValid() {
        return this.method.isValid();
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/asJava/KtLightParameter", "setName"));
        }
        KtParameter origin = this.getKotlinOrigin();
        if (origin != null) {
            origin.setName(name);
        }
        return this;
    }

    @Override
    public PsiFile getContainingFile() {
        return this.method.getContainingFile();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        if (kotlinLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtLightParameter", "getLanguage"));
        }
        return kotlinLanguage;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        KtParameter origin = this.getKotlinOrigin();
        SearchScope searchScope = origin != null ? origin.getUseScope() : GlobalSearchScope.EMPTY_SCOPE;
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtLightParameter", "getUseScope"));
        }
        return searchScope;
    }

    public KtLightMethod getMethod() {
        return this.method;
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public TextRange getTextRange() {
        KtParameter origin = this.getKotlinOrigin();
        return origin != null ? origin.getTextRange() : TextRange.EMPTY_RANGE;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        if (this.lightIdentifier == null) {
            this.lightIdentifier = new KtLightIdentifier(this, this.getKotlinOrigin());
        }
        return this.lightIdentifier;
    }

    @Override
    public PsiElement getParent() {
        return this.getMethod().getParameterList();
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        KtParameter kotlinOrigin2 = this.getKotlinOrigin();
        if (another instanceof KtLightParameter && kotlinOrigin2 != null) {
            KtLightParameter anotherParam = (KtLightParameter)another;
            return kotlinOrigin2.equals(anotherParam.getKotlinOrigin()) && this.getClsDelegate().equals(anotherParam.getClsDelegate());
        }
        return super.isEquivalentTo(another);
    }
}

