/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.WhenOnSealedExhaustivenessChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00018B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J \u0010\u001b\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J0\u0010 \u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010#\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010\f\u001a\u00020\rH\u0002J2\u0010&\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J0\u0010)\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070,H\u0002J4\u0010-\u001a\u00020.2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010/\u001a\u0004\u0018\u00010\u000f2\u0006\u00100\u001a\u00020\"2\b\u00101\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u00102\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0018\u00103\u001a\u00020.2\u0006\u0010\b\u001a\u0002042\u0006\u0010*\u001a\u00020\u000bH\u0016J\u0018\u00105\u001a\u00020.2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J \u00105\u001a\u00020.2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u000b2\b\b\u0001\u00106\u001a\u00020\"J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00160,2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingVisitor;", "facade", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;)V", "analyzeConditionsInWhenEntries", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "contextAfterSubject", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "subjectDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "subjectType", "Lorg/jetbrains/kotlin/types/KotlinType;", "analyzeWhenEntryConditions", "Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$ConditionalDataFlowInfo;", "whenEntry", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "context", "subjectExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkSmartCastToExpectedTypeInSubject", "", "contextBeforeSubject", "expectedType", "checkSmartCastsInSubjectIfRequired", "checkTypeCompatibility", "type", "reportErrorOn", "Lorg/jetbrains/kotlin/psi/KtElement;", "checkTypeForExpressionCondition", "conditionExpected", "", "checkTypeForIs", "typeReferenceAfterIs", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "checkWhenCondition", "condition", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "inferTypeForWhenExpression", "contextWithExpectedType", "dataFlowInfoForEntries", "", "joinWhenExpressionBranches", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "resultType", "jumpOutPossibleInSubject", "whenResultValue", "noChange", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitWhenExpression", "isStatement", "wrapWhenEntryExpressionsAsSpecialCallArguments", "ConditionalDataFlowInfo", "kotlin-compiler"})
public final class PatternMatchingTypingVisitor
extends ExpressionTypingVisitor {
    @Override
    @NotNull
    public KotlinTypeInfo visitIsExpression(@NotNull KtIsExpression expression, @NotNull ExpressionTypingContext contextWithExpectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(contextWithExpectedType, "contextWithExpectedType");
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression leftHandSide = expression.getLeftHandSide();
        KotlinTypeInfo typeInfo = this.facade.safeGetTypeInfo(leftHandSide, (ExpressionTypingContext)context.replaceScope(context.scope));
        KotlinType knownType = typeInfo.getType();
        KtTypeReference typeReference = expression.getTypeReference();
        if (typeReference != null && knownType != null) {
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(leftHandSide, knownType, context);
            ExpressionTypingContext expressionTypingContext = context;
            Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext, "context");
            DataFlowValue dataFlowValue2 = dataFlowValue;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowValue2, "dataFlowValue");
            DataFlowInfo conditionInfo = this.checkTypeForIs(expressionTypingContext, knownType, typeReference, dataFlowValue2).getThenInfo();
            DataFlowInfo newDataFlowInfo = conditionInfo.and(typeInfo.getDataFlowInfo());
            context.trace.record(BindingContext.DATAFLOW_INFO_AFTER_CONDITION, expression, newDataFlowInfo);
        }
        KotlinTypeInfo kotlinTypeInfo = this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(this.components.builtIns.getBooleanType()), (KtExpression)expression, (ResolutionContext)contextWithExpectedType);
        Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "components.dataFlowAnaly\u2026 contextWithExpectedType)");
        return kotlinTypeInfo;
    }

    @Override
    @NotNull
    public KotlinTypeInfo visitWhenExpression(@NotNull KtWhenExpression expression, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return this.visitWhenExpression(expression, context, false);
    }

    @NotNull
    public final KotlinTypeInfo visitWhenExpression(@NotNull KtWhenExpression expression, @NotNull ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        DataFlowInfo resultDataFlowInfo;
        DataFlowInfo dataFlowInfo;
        DataFlowValue dataFlowValue;
        KotlinType whenReturnType;
        Object object;
        boolean jumpOutPossibleInSubject;
        Object subjectType;
        ExpressionTypingContext contextAfterSubject;
        ExpressionTypingContext contextBeforeSubject;
        BindingTrace trace;
        block18: {
            block17: {
                Object object2;
                ExpressionTypingContext subjectTypeInfo;
                KtExpression subjectExpression;
                block16: {
                    ExpressionTypingContext expressionTypingContext;
                    block15: {
                        Object object3;
                        KtExpression it;
                        Intrinsics.checkParameterIsNotNull(expression, "expression");
                        Intrinsics.checkParameterIsNotNull(contextWithExpectedType, "contextWithExpectedType");
                        BindingTrace bindingTrace = trace = contextWithExpectedType.trace;
                        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "trace");
                        WhenChecker.INSTANCE.checkDeprecatedWhenSyntax(bindingTrace, expression);
                        BindingTrace bindingTrace2 = trace;
                        Intrinsics.checkExpressionValueIsNotNull(bindingTrace2, "trace");
                        WhenChecker.INSTANCE.checkReservedPrefix(bindingTrace2, expression);
                        this.components.dataFlowAnalyzer.recordExpectedType(trace, expression, contextWithExpectedType.expectedType);
                        contextBeforeSubject = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
                        KtExpression ktExpression = subjectExpression = expression.getSubjectExpression();
                        if (ktExpression != null) {
                            KtExpression ktExpression2 = ktExpression;
                            it = ktExpression2;
                            object3 = this.facade.getTypeInfo(it, contextBeforeSubject);
                        } else {
                            object3 = null;
                        }
                        if ((expressionTypingContext = (subjectTypeInfo = object3)) == null) break block15;
                        it = expressionTypingContext;
                        KotlinTypeInfo it2 = (KotlinTypeInfo)((Object)it);
                        expressionTypingContext = (ExpressionTypingContext)contextBeforeSubject.replaceDataFlowInfo(it2.getDataFlowInfo());
                        if (expressionTypingContext != null) break block16;
                    }
                    expressionTypingContext = contextAfterSubject = contextBeforeSubject;
                }
                if ((object2 = subjectTypeInfo) == null || (object2 = ((KotlinTypeInfo)object2).getType()) == null) {
                    KotlinType kotlinType = ErrorUtils.createErrorType("Unknown type");
                    object2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "ErrorUtils.createErrorType(\"Unknown type\")");
                }
                subjectType = object2;
                ExpressionTypingContext expressionTypingContext = subjectTypeInfo;
                jumpOutPossibleInSubject = expressionTypingContext != null ? ((KotlinTypeInfo)((Object)expressionTypingContext)).getJumpOutPossible() : false;
                object = subjectExpression;
                if (object == null) break block17;
                KtExpression ktExpression = object;
                KtExpression it = ktExpression;
                object = DataFlowValueFactory.createDataFlowValue(it, (KotlinType)subjectType, contextAfterSubject);
                if (object != null) break block18;
            }
            KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
            Intrinsics.checkExpressionValueIsNotNull(kotlinBuiltIns, "components.builtIns");
            object = DataFlowValue.Companion.nullValue(kotlinBuiltIns);
        }
        Object subjectDataFlowValue = object;
        ExpressionTypingContext expressionTypingContext = contextBeforeSubject;
        Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext, "contextBeforeSubject");
        this.checkSmartCastsInSubjectIfRequired(expression, expressionTypingContext, (KotlinType)subjectType);
        ExpressionTypingContext expressionTypingContext2 = contextAfterSubject;
        Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext2, "contextAfterSubject");
        Object object4 = subjectDataFlowValue;
        Intrinsics.checkExpressionValueIsNotNull(object4, "subjectDataFlowValue");
        ArrayList<DataFlowInfo> dataFlowInfoForEntries = this.analyzeConditionsInWhenEntries(expression, expressionTypingContext2, (DataFlowValue)object4, (KotlinType)subjectType);
        ExpressionTypingContext expressionTypingContext3 = contextAfterSubject;
        Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext3, "contextAfterSubject");
        KotlinType kotlinType = whenReturnType = this.inferTypeForWhenExpression(expression, contextWithExpectedType, expressionTypingContext3, (List<? extends DataFlowInfo>)dataFlowInfoForEntries);
        if (kotlinType != null) {
            KotlinType kotlinType2 = kotlinType;
            KotlinType it = kotlinType2;
            dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, it, contextAfterSubject);
        } else {
            dataFlowValue = null;
        }
        DataFlowValue whenResultValue = dataFlowValue;
        ExpressionTypingContext expressionTypingContext4 = contextAfterSubject;
        Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext4, "contextAfterSubject");
        KotlinTypeInfo branchesTypeInfo = this.joinWhenExpressionBranches(expression, expressionTypingContext4, whenReturnType, jumpOutPossibleInSubject, whenResultValue);
        BindingTrace bindingTrace = trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "trace");
        boolean isExhaustive = WhenChecker.isWhenExhaustive(expression, bindingTrace);
        DataFlowInfo branchesDataFlowInfo = branchesTypeInfo.getDataFlowInfo();
        if (expression.getElseExpression() == null && !isExhaustive) {
            DataFlowInfo dataFlowInfo2 = contextAfterSubject.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo2, "contextAfterSubject.dataFlowInfo");
            dataFlowInfo = branchesDataFlowInfo.or(dataFlowInfo2);
        } else {
            dataFlowInfo = resultDataFlowInfo = branchesDataFlowInfo;
        }
        if (whenReturnType != null && isExhaustive && expression.getElseExpression() == null && KotlinBuiltIns.isNothing(whenReturnType)) {
            trace.record(BindingContext.IMPLICIT_EXHAUSTIVE_WHEN, expression);
        }
        KotlinType kotlinType3 = branchesTypeInfo.getType();
        if (kotlinType3 == null) {
            return TypeInfoFactoryKt.noTypeInfo(resultDataFlowInfo);
        }
        KotlinType branchesType = kotlinType3;
        KotlinType resultType = this.components.dataFlowAnalyzer.checkType(branchesType, (KtExpression)expression, (ResolutionContext)contextWithExpectedType);
        boolean bl = branchesTypeInfo.getJumpOutPossible();
        DataFlowInfo dataFlowInfo3 = contextWithExpectedType.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo3, "contextWithExpectedType.dataFlowInfo");
        return TypeInfoFactoryKt.createTypeInfo(resultType, resultDataFlowInfo, bl, dataFlowInfo3);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType inferTypeForWhenExpression(KtWhenExpression expression, ExpressionTypingContext contextWithExpectedType, ExpressionTypingContext contextAfterSubject, List<? extends DataFlowInfo> dataFlowInfoForEntries) {
        boolean bl;
        block2: {
            void $receiver$iv;
            Iterable iterable = expression.getEntries();
            for (Object element$iv : $receiver$iv) {
                KtWhenEntry it = (KtWhenEntry)element$iv;
                if (it.getExpression() == null) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        if (bl) {
            return this.components.builtIns.getUnitType();
        }
        List<KtExpression> wrappedArgumentExpressions = this.wrapWhenEntryExpressionsAsSpecialCallArguments(expression);
        Call callForWhen = ControlStructureTypingUtils.createCallForSpecialConstruction(expression, expression, wrappedArgumentExpressions);
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = ControlStructureTypingUtils.createDataFlowInfoForArgumentsOfWhenCall(callForWhen, contextAfterSubject.dataFlowInfo, dataFlowInfoForEntries);
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(callForWhen, ControlStructureTypingUtils.ResolveConstruct.WHEN, (List<String>)new AbstractList<String>(wrappedArgumentExpressions){
            final /* synthetic */ List $wrappedArgumentExpressions;

            @NotNull
            public String get(int index2) {
                return "entry" + index2;
            }

            public int getSize() {
                return this.$wrappedArgumentExpressions.size();
            }
            {
                this.$wrappedArgumentExpressions = $captured_local_variable$0;
            }
        }, Collections.nCopies(wrappedArgumentExpressions.size(), false), contextWithExpectedType, dataFlowInfoForArguments);
        return resolvedCall2.getResultingDescriptor().getReturnType();
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtExpression> wrapWhenEntryExpressionsAsSpecialCallArguments(KtWhenExpression expression) {
        void destination$iv$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory(expression);
        Iterable iterable = expression.getEntries();
        void var5_4 = $receiver$iv;
        Collection collection = new ArrayList();
        void var7_6 = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            KtBlockExpression ktBlockExpression;
            Object element$iv$iv = element$iv$iv$iv;
            KtWhenEntry whenEntry = (KtWhenEntry)element$iv$iv;
            if (whenEntry.getExpression() != null) {
                KtExpression ktExpression;
                KtExpression it;
                KtExpression ktExpression2 = it = ktExpression;
                Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "it");
                ktBlockExpression = psiFactory.wrapInABlockWrapper(ktExpression2);
            } else {
                ktBlockExpression = null;
            }
            if (ktBlockExpression == null) continue;
            KtBlockExpression ktBlockExpression2 = ktBlockExpression;
            KtBlockExpression it$iv$iv = ktBlockExpression2;
            destination$iv$iv.add(it$iv$iv);
        }
        List wrappedArgumentExpressions = (List)destination$iv$iv;
        return wrappedArgumentExpressions;
    }

    private final ArrayList<DataFlowInfo> analyzeConditionsInWhenEntries(KtWhenExpression expression, ExpressionTypingContext contextAfterSubject, DataFlowValue subjectDataFlowValue, KotlinType subjectType) {
        KtExpression subjectExpression = expression.getSubjectExpression();
        ArrayList<DataFlowInfo> argumentDataFlowInfos = new ArrayList<DataFlowInfo>();
        DataFlowInfo inputDataFlowInfo = contextAfterSubject.dataFlowInfo;
        Iterator<KtWhenEntry> iterator2 = expression.getEntries().iterator();
        while (iterator2.hasNext()) {
            KtWhenEntry whenEntry;
            KtWhenEntry ktWhenEntry = whenEntry = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(ktWhenEntry, "whenEntry");
            ExpressionTypingContext expressionTypingContext = (ExpressionTypingContext)contextAfterSubject.replaceDataFlowInfo(inputDataFlowInfo);
            Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext, "contextAfterSubject.repl\u2026owInfo(inputDataFlowInfo)");
            ConditionalDataFlowInfo conditionsInfo = this.analyzeWhenEntryConditions(ktWhenEntry, expressionTypingContext, subjectExpression, subjectType, subjectDataFlowValue);
            inputDataFlowInfo = inputDataFlowInfo.and(conditionsInfo.getElseInfo());
            if (whenEntry.getExpression() == null) continue;
            argumentDataFlowInfos.add(conditionsInfo.getThenInfo());
        }
        return argumentDataFlowInfos;
    }

    private final KotlinTypeInfo joinWhenExpressionBranches(KtWhenExpression expression, ExpressionTypingContext contextAfterSubject, KotlinType resultType, boolean jumpOutPossibleInSubject, DataFlowValue whenResultValue) {
        BindingContext bindingContext = contextAfterSubject.trace.getBindingContext();
        DataFlowInfo currentDataFlowInfo = null;
        boolean jumpOutPossible = jumpOutPossibleInSubject;
        boolean errorTypeExistInBranch = false;
        for (KtWhenEntry whenEntry : expression.getEntries()) {
            DataFlowInfo entryDataFlowInfo;
            DataFlowInfo dataFlowInfo;
            KotlinTypeInfo entryTypeInfo;
            KtExpression entryExpression;
            if (whenEntry.getExpression() == null) {
                continue;
            }
            if (BindingContextUtils.getRecordedTypeInfo(entryExpression, bindingContext) == null) {
                continue;
            }
            KotlinType entryType = entryTypeInfo.getType();
            if (entryType == null) {
                errorTypeExistInBranch = true;
            }
            if (whenResultValue != null && entryType != null) {
                DataFlowValue entryValue = DataFlowValueFactory.createDataFlowValue(entryExpression, entryType, contextAfterSubject);
                DataFlowInfo dataFlowInfo2 = entryTypeInfo.getDataFlowInfo();
                DataFlowValue dataFlowValue = entryValue;
                Intrinsics.checkExpressionValueIsNotNull(dataFlowValue, "entryValue");
                dataFlowInfo = dataFlowInfo2.assign(whenResultValue, dataFlowValue);
            } else {
                dataFlowInfo = entryDataFlowInfo = entryTypeInfo.getDataFlowInfo();
            }
            currentDataFlowInfo = entryType != null && KotlinBuiltIns.isNothing(entryType) ? currentDataFlowInfo : (currentDataFlowInfo != null ? currentDataFlowInfo.or(entryDataFlowInfo) : entryDataFlowInfo);
            jumpOutPossible |= entryTypeInfo.getJumpOutPossible();
        }
        DataFlowInfo dataFlowInfo = currentDataFlowInfo;
        if (dataFlowInfo == null) {
            DataFlowInfo dataFlowInfo3 = contextAfterSubject.dataFlowInfo;
            dataFlowInfo = dataFlowInfo3;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo3, "contextAfterSubject.dataFlowInfo");
        }
        DataFlowInfo resultDataFlowInfo = dataFlowInfo;
        return resultType == null || errorTypeExistInBranch && KotlinBuiltIns.isNothing(resultType) ? TypeInfoFactoryKt.noTypeInfo(resultDataFlowInfo) : TypeInfoFactoryKt.createTypeInfo(resultType, resultDataFlowInfo, jumpOutPossible, resultDataFlowInfo);
    }

    private final void checkSmartCastsInSubjectIfRequired(KtWhenExpression expression, ExpressionTypingContext contextBeforeSubject, KotlinType subjectType) {
        ClassifierDescriptor classifierDescriptor;
        KtExpression ktExpression = expression.getSubjectExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression subjectExpression = ktExpression;
        boolean nullableType = TypeUtils.isNullableType(subjectType);
        BindingContext bindingContext = contextBeforeSubject.trace.getBindingContext();
        if (nullableType) {
            BindingContext bindingContext2 = bindingContext;
            Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "bindingContext");
            if (!WhenChecker.INSTANCE.containsNullCase(expression, bindingContext2)) {
                KotlinType notNullableType = TypeUtils.makeNotNullable(subjectType);
                KtExpression ktExpression2 = subjectExpression;
                Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "subjectExpression");
                KotlinType kotlinType = notNullableType;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "notNullableType");
                this.checkSmartCastToExpectedTypeInSubject(contextBeforeSubject, ktExpression2, subjectType, kotlinType);
            }
        }
        if (!((classifierDescriptor = subjectType.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor subjectClass = classDescriptor;
        if (Intrinsics.areEqual((Object)subjectClass.getModality(), (Object)Modality.SEALED)) {
            BindingContext bindingContext3 = bindingContext;
            Intrinsics.checkExpressionValueIsNotNull(bindingContext3, "bindingContext");
            Collection collection = WhenOnSealedExhaustivenessChecker.INSTANCE.getMissingCases(expression, bindingContext3, subjectClass, false);
            if (!collection.isEmpty()) {
                for (ClassDescriptor descriptor2 : WhenOnSealedExhaustivenessChecker.INSTANCE.getNestedSubclasses$kotlin_compiler(subjectClass)) {
                    if (!Intrinsics.areEqual((Object)descriptor2.getModality(), (Object)Modality.SEALED) || !DescriptorUtils.isDirectSubclass(descriptor2, subjectClass)) continue;
                    KtExpression ktExpression3 = subjectExpression;
                    Intrinsics.checkExpressionValueIsNotNull(ktExpression3, "subjectExpression");
                    KotlinType kotlinType = descriptor2.getDefaultType();
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "descriptor.defaultType");
                    this.checkSmartCastToExpectedTypeInSubject(contextBeforeSubject, ktExpression3, subjectType, kotlinType);
                }
            }
        }
    }

    private final void checkSmartCastToExpectedTypeInSubject(ExpressionTypingContext contextBeforeSubject, KtExpression subjectExpression, KotlinType subjectType, KotlinType expectedType) {
        TemporaryBindingTrace trace = TemporaryBindingTrace.create(contextBeforeSubject.trace, "Temporary trace for when subject nullability");
        ExpressionTypingContext subjectContext = (ExpressionTypingContext)((ExpressionTypingContext)contextBeforeSubject.replaceExpectedType(expectedType)).replaceBindingTrace(trace);
        SmartCastResult castResult = DataFlowAnalyzer.checkPossibleCast(subjectType, KtPsiUtil.safeDeparenthesize(subjectExpression), subjectContext);
        if (castResult != null && castResult.isCorrect()) {
            trace.commit();
        }
    }

    private final ConditionalDataFlowInfo analyzeWhenEntryConditions(KtWhenEntry whenEntry, ExpressionTypingContext context, KtExpression subjectExpression, KotlinType subjectType, DataFlowValue subjectDataFlowValue) {
        if (whenEntry.isElse()) {
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
            return new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
        }
        ConditionalDataFlowInfo entryInfo = null;
        ExpressionTypingContext contextForCondition = context;
        KtWhenCondition[] ktWhenConditionArray = whenEntry.getConditions();
        for (int i = 0; i < ktWhenConditionArray.length; ++i) {
            ConditionalDataFlowInfo conditionalDataFlowInfo;
            KtWhenCondition condition;
            KtWhenCondition ktWhenCondition = condition = ktWhenConditionArray[i];
            Intrinsics.checkExpressionValueIsNotNull(ktWhenCondition, "condition");
            ConditionalDataFlowInfo conditionInfo = this.checkWhenCondition(subjectExpression, subjectType, ktWhenCondition, contextForCondition, subjectDataFlowValue);
            if (entryInfo != null) {
                ConditionalDataFlowInfo conditionalDataFlowInfo2;
                ConditionalDataFlowInfo it = conditionalDataFlowInfo2;
                conditionalDataFlowInfo = new ConditionalDataFlowInfo(it.getThenInfo().or(conditionInfo.getThenInfo()), it.getElseInfo().and(conditionInfo.getElseInfo()));
            } else {
                conditionalDataFlowInfo = conditionInfo;
            }
            entryInfo = conditionalDataFlowInfo;
            Object Context2 = contextForCondition.replaceDataFlowInfo(conditionInfo.getElseInfo());
            Intrinsics.checkExpressionValueIsNotNull(Context2, "contextForCondition.repl\u2026o(conditionInfo.elseInfo)");
            contextForCondition = (ExpressionTypingContext)Context2;
        }
        ConditionalDataFlowInfo conditionalDataFlowInfo = entryInfo;
        if (conditionalDataFlowInfo == null) {
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
            conditionalDataFlowInfo = new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
        }
        return conditionalDataFlowInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final ConditionalDataFlowInfo checkWhenCondition(KtExpression subjectExpression, KotlinType subjectType, KtWhenCondition condition, ExpressionTypingContext context, DataFlowValue subjectDataFlowValue) {
        void newDataFlowInfo;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.noChange(context);
        condition.accept(new KtVisitorVoid(this, subjectExpression, context, (Ref.ObjectRef)newDataFlowInfo, subjectType, subjectDataFlowValue){
            final /* synthetic */ PatternMatchingTypingVisitor this$0;
            final /* synthetic */ KtExpression $subjectExpression;
            final /* synthetic */ ExpressionTypingContext $context;
            final /* synthetic */ Ref.ObjectRef $newDataFlowInfo;
            final /* synthetic */ KotlinType $subjectType;
            final /* synthetic */ DataFlowValue $subjectDataFlowValue;

            public void visitWhenConditionInRange(@NotNull KtWhenConditionInRange condition) {
                Intrinsics.checkParameterIsNotNull(condition, "condition");
                KtExpression ktExpression = condition.getRangeExpression();
                if (ktExpression == null) {
                    return;
                }
                KtExpression rangeExpression = ktExpression;
                if (this.$subjectExpression == null) {
                    this.$context.trace.report(Errors.EXPECTED_CONDITION.on((KtWhenCondition)((PsiElement)condition)));
                    DataFlowInfo dataFlowInfo = this.this$0.facade.getTypeInfo(rangeExpression, this.$context).getDataFlowInfo();
                    this.$newDataFlowInfo.element = new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
                    return;
                }
                ValueArgument argumentForSubject = CallMaker.makeExternalValueArgument(this.$subjectExpression);
                KotlinTypeInfo typeInfo = this.this$0.facade.checkInExpression(condition, condition.getOperationReference(), argumentForSubject, rangeExpression, this.$context);
                DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
                this.$newDataFlowInfo.element = new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
                KotlinType type2 = typeInfo.getType();
                if (type2 == null || !KotlinBuiltIns.isBoolean(type2)) {
                    this.$context.trace.report(Errors.TYPE_MISMATCH_IN_RANGE.on((KtWhenConditionInRange)((PsiElement)condition)));
                }
            }

            public void visitWhenConditionIsPattern(@NotNull KtWhenConditionIsPattern condition) {
                KtTypeReference typeReference;
                Intrinsics.checkParameterIsNotNull(condition, "condition");
                if (this.$subjectExpression == null) {
                    this.$context.trace.report(Errors.EXPECTED_CONDITION.on((KtWhenCondition)((PsiElement)condition)));
                }
                if ((typeReference = condition.getTypeReference()) != null) {
                    ConditionalDataFlowInfo result2 = PatternMatchingTypingVisitor.access$checkTypeForIs(this.this$0, this.$context, this.$subjectType, typeReference, this.$subjectDataFlowValue);
                    this.$newDataFlowInfo.element = condition.isNegated() ? new ConditionalDataFlowInfo(result2.getElseInfo(), result2.getThenInfo()) : result2;
                }
            }

            public void visitWhenConditionWithExpression(@NotNull KtWhenConditionWithExpression condition) {
                Intrinsics.checkParameterIsNotNull(condition, "condition");
                KtExpression expression = condition.getExpression();
                if (expression != null) {
                    this.$newDataFlowInfo.element = PatternMatchingTypingVisitor.access$checkTypeForExpressionCondition(this.this$0, this.$context, expression, this.$subjectType, this.$subjectExpression == null, this.$subjectDataFlowValue);
                }
            }

            public void visitKtElement(@NotNull KtElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                this.$context.trace.report(Errors.UNSUPPORTED.on(element, this.getClass().getCanonicalName()));
            }
            {
                this.this$0 = $outer;
                this.$subjectExpression = $captured_local_variable$1;
                this.$context = $captured_local_variable$2;
                this.$newDataFlowInfo = $captured_local_variable$3;
                this.$subjectType = $captured_local_variable$4;
                this.$subjectDataFlowValue = $captured_local_variable$5;
            }
        });
        return (ConditionalDataFlowInfo)newDataFlowInfo.element;
    }

    private final ConditionalDataFlowInfo checkTypeForExpressionCondition(ExpressionTypingContext context, KtExpression expression, KotlinType subjectType, boolean conditionExpected, DataFlowValue subjectDataFlowValue) {
        ExpressionTypingContext newContext = context;
        KotlinTypeInfo typeInfo = this.facade.getTypeInfo(expression, newContext);
        KotlinType kotlinType = typeInfo.getType();
        if (kotlinType == null) {
            return this.noChange(newContext);
        }
        KotlinType type2 = kotlinType;
        Object Context2 = newContext.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        Intrinsics.checkExpressionValueIsNotNull(Context2, "newContext.replaceDataFl\u2026fo(typeInfo.dataFlowInfo)");
        newContext = (ExpressionTypingContext)Context2;
        if (conditionExpected) {
            KotlinType booleanType = this.components.builtIns.getBooleanType();
            KotlinTypeInfo checkedTypeInfo = this.components.dataFlowAnalyzer.checkType(typeInfo, expression, (ResolutionContext)newContext.replaceExpectedType(booleanType));
            KotlinType kotlinType2 = checkedTypeInfo.getType();
            if (kotlinType2 == null) {
                kotlinType2 = type2;
            }
            if (KotlinTypeChecker.DEFAULT.equalTypes(booleanType, kotlinType2)) {
                DataFlowInfo ifInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(expression, true, newContext);
                DataFlowInfo elseInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(expression, false, newContext);
                DataFlowInfo dataFlowInfo = ifInfo;
                Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "ifInfo");
                DataFlowInfo dataFlowInfo2 = elseInfo;
                Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo2, "elseInfo");
                return new ConditionalDataFlowInfo(dataFlowInfo, dataFlowInfo2);
            }
            return this.noChange(newContext);
        }
        this.checkTypeCompatibility(newContext, type2, subjectType, expression);
        DataFlowValue expressionDataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, type2, newContext);
        ConditionalDataFlowInfo result2 = this.noChange(newContext);
        DataFlowInfo dataFlowInfo = result2.getThenInfo();
        DataFlowValue dataFlowValue = expressionDataFlowValue;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowValue, "expressionDataFlowValue");
        DataFlowInfo dataFlowInfo3 = dataFlowInfo.equate(subjectDataFlowValue, dataFlowValue, DataFlowAnalyzer.typeHasEqualsFromAny(subjectType, expression));
        DataFlowInfo dataFlowInfo4 = result2.getElseInfo();
        DataFlowValue dataFlowValue2 = expressionDataFlowValue;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowValue2, "expressionDataFlowValue");
        return new ConditionalDataFlowInfo(dataFlowInfo3, dataFlowInfo4.disequate(subjectDataFlowValue, dataFlowValue2));
    }

    private final ConditionalDataFlowInfo checkTypeForIs(ExpressionTypingContext context, KotlinType subjectType, KtTypeReference typeReferenceAfterIs, DataFlowValue subjectDataFlowValue) {
        ClassDescriptor targetDescriptor;
        TypeResolutionContext typeResolutionContext = new TypeResolutionContext(context.scope, context.trace, true, true, context.isDebuggerContext);
        PossiblyBareType possiblyBareTarget = this.components.typeResolver.resolvePossiblyBareType(typeResolutionContext, typeReferenceAfterIs);
        KotlinType targetType = TypeReconstructionUtil.reconstructBareType(typeReferenceAfterIs, possiblyBareTarget, subjectType, context.trace, this.components.builtIns);
        if (DynamicTypesKt.isDynamic(targetType)) {
            context.trace.report(Errors.DYNAMIC_NOT_ALLOWED.on((KtTypeReference)((PsiElement)typeReferenceAfterIs)));
        }
        if ((targetDescriptor = TypeUtils.getClassDescriptor(targetType)) != null && DescriptorUtils.isEnumEntry(targetDescriptor)) {
            context.trace.report(Errors.IS_ENUM_ENTRY.on((KtTypeReference)((PsiElement)typeReferenceAfterIs)));
        }
        if (!subjectType.isMarkedNullable() && targetType.isMarkedNullable()) {
            KtTypeElement element = typeReferenceAfterIs.getTypeElement();
            boolean bl = element instanceof KtNullableType;
            if (_Assertions.ENABLED && !bl) {
                String string = "element must be instance of " + KtNullableType.class.getName();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            KtTypeElement ktTypeElement = element;
            if (ktTypeElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNullableType");
            }
            context.trace.report(Errors.USELESS_NULLABLE_CHECK.on((KtNullableType)((PsiElement)((KtNullableType)ktTypeElement))));
        }
        KotlinType kotlinType = targetType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "targetType");
        this.checkTypeCompatibility(context, kotlinType, subjectType, typeReferenceAfterIs);
        KotlinType kotlinType2 = targetType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "targetType");
        KotlinTypeChecker kotlinTypeChecker = KotlinTypeChecker.DEFAULT;
        Intrinsics.checkExpressionValueIsNotNull(kotlinTypeChecker, "KotlinTypeChecker.DEFAULT");
        if (CastDiagnosticsUtil.isCastErased(subjectType, kotlinType2, kotlinTypeChecker)) {
            context.trace.report(Errors.CANNOT_CHECK_FOR_ERASED.on((KtElement)((PsiElement)typeReferenceAfterIs), targetType));
        }
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        KotlinType kotlinType3 = targetType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "targetType");
        DataFlowInfo dataFlowInfo2 = dataFlowInfo.establishSubtyping(subjectDataFlowValue, kotlinType3);
        DataFlowInfo dataFlowInfo3 = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo3, "context.dataFlowInfo");
        return new ConditionalDataFlowInfo(dataFlowInfo2, dataFlowInfo3);
    }

    private final ConditionalDataFlowInfo noChange(ExpressionTypingContext context) {
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
        return new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
    }

    private final void checkTypeCompatibility(ExpressionTypingContext context, KotlinType type2, KotlinType subjectType, KtElement reportErrorOn) {
        if (TypeIntersector.isIntersectionEmpty(type2, subjectType)) {
            context.trace.report(Errors.INCOMPATIBLE_TYPES.on((KtElement)((PsiElement)reportErrorOn), type2, subjectType));
            return;
        }
        if (KotlinBuiltIns.isNullableNothing(type2) && !TypeUtils.isNullableType(subjectType)) {
            context.trace.report(Errors.SENSELESS_NULL_IN_WHEN.on((KtElement)((PsiElement)reportErrorOn)));
        }
    }

    public PatternMatchingTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        Intrinsics.checkParameterIsNotNull(facade, "facade");
        super(facade);
    }

    @NotNull
    public static final /* synthetic */ ConditionalDataFlowInfo access$checkTypeForIs(PatternMatchingTypingVisitor $this, @NotNull ExpressionTypingContext context, @NotNull KotlinType subjectType, @NotNull KtTypeReference typeReferenceAfterIs, @NotNull DataFlowValue subjectDataFlowValue) {
        return $this.checkTypeForIs(context, subjectType, typeReferenceAfterIs, subjectDataFlowValue);
    }

    @NotNull
    public static final /* synthetic */ ConditionalDataFlowInfo access$checkTypeForExpressionCondition(PatternMatchingTypingVisitor $this, @NotNull ExpressionTypingContext context, @NotNull KtExpression expression, @NotNull KotlinType subjectType, boolean conditionExpected, @NotNull DataFlowValue subjectDataFlowValue) {
        return $this.checkTypeForExpressionCondition(context, expression, subjectType, conditionExpected, subjectDataFlowValue);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$ConditionalDataFlowInfo;", "", "thenInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "elseInfo", "(Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;)V", "getElseInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getThenInfo", "kotlin-compiler"})
    private static final class ConditionalDataFlowInfo {
        @NotNull
        private final DataFlowInfo thenInfo;
        @NotNull
        private final DataFlowInfo elseInfo;

        @NotNull
        public final DataFlowInfo getThenInfo() {
            return this.thenInfo;
        }

        @NotNull
        public final DataFlowInfo getElseInfo() {
            return this.elseInfo;
        }

        public ConditionalDataFlowInfo(@NotNull DataFlowInfo thenInfo, @NotNull DataFlowInfo elseInfo) {
            Intrinsics.checkParameterIsNotNull(thenInfo, "thenInfo");
            Intrinsics.checkParameterIsNotNull(elseInfo, "elseInfo");
            this.thenInfo = thenInfo;
            this.elseInfo = elseInfo;
        }

        public /* synthetic */ ConditionalDataFlowInfo(DataFlowInfo dataFlowInfo, DataFlowInfo dataFlowInfo2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                dataFlowInfo2 = dataFlowInfo;
            }
            this(dataFlowInfo, dataFlowInfo2);
        }
    }
}

