/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class ExtendedStringLiteral
extends StringLiteral {
    public ExtendedStringLiteral(StringLiteral stringLiteral, CharLiteral charLiteral) {
        super(stringLiteral.source, stringLiteral.sourceStart, stringLiteral.sourceEnd, stringLiteral.lineNumber);
        this.extendWith(charLiteral);
    }

    public ExtendedStringLiteral(StringLiteral stringLiteral, StringLiteral stringLiteral2) {
        super(stringLiteral.source, stringLiteral.sourceStart, stringLiteral.sourceEnd, stringLiteral.lineNumber);
        this.extendWith(stringLiteral2);
    }

    @Override
    public ExtendedStringLiteral extendWith(CharLiteral charLiteral) {
        int n = this.source.length;
        this.source = new char[n + 1];
        System.arraycopy(this.source, 0, this.source, 0, n);
        this.source[n] = charLiteral.value;
        this.sourceEnd = charLiteral.sourceEnd;
        return this;
    }

    @Override
    public ExtendedStringLiteral extendWith(StringLiteral stringLiteral) {
        int n = this.source.length;
        this.source = new char[n + stringLiteral.source.length];
        System.arraycopy(this.source, 0, this.source, 0, n);
        System.arraycopy(stringLiteral.source, 0, this.source, n, stringLiteral.source.length);
        this.sourceEnd = stringLiteral.sourceEnd;
        return this;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        return stringBuffer.append("ExtendedStringLiteral{").append(this.source).append('}');
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }
}

