/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClassImpl;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;

public abstract class NodeClass {
    private static final ClassValue<NodeClass> nodeClasses = new ClassValue<NodeClass>(){

        @Override
        protected NodeClass computeValue(final Class<?> clazz) {
            assert (Node.class.isAssignableFrom(clazz));
            return AccessController.doPrivileged(new PrivilegedAction<NodeClass>(){

                @Override
                public NodeClass run() {
                    return new NodeClassImpl(clazz);
                }
            });
        }
    };

    public static NodeClass get(Class<? extends Node> clazz) {
        return nodeClasses.get(clazz);
    }

    public static NodeClass get(Node node) {
        return node.getNodeClass();
    }

    public NodeClass(Class<? extends Node> clazz) {
    }

    public abstract NodeFieldAccessor getNodeClassField();

    public abstract NodeFieldAccessor[] getCloneableFields();

    public abstract NodeFieldAccessor[] getFields();

    public abstract NodeFieldAccessor getParentField();

    public abstract NodeFieldAccessor[] getChildFields();

    public abstract NodeFieldAccessor[] getChildrenFields();

    public abstract Iterator<Node> makeIterator(Node var1);

    public abstract Class<? extends Node> getType();
}

