/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.hash;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.basicobject.BasicObjectNodes;
import org.jruby.truffle.core.basicobject.BasicObjectNodesFactory;
import org.jruby.truffle.core.hash.BucketsStrategy;
import org.jruby.truffle.core.hash.Entry;
import org.jruby.truffle.core.hash.HashLookupResult;
import org.jruby.truffle.core.hash.HashNode;
import org.jruby.truffle.language.RubyBaseNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

public class LookupEntryNode
extends RubyBaseNode {
    @Node.Child
    HashNode hashNode;
    @Node.Child
    CallDispatchHeadNode eqlNode;
    @Node.Child
    BasicObjectNodes.ReferenceEqualNode equalNode;
    private final ConditionProfile byIdentityProfile = ConditionProfile.createBinaryProfile();

    public LookupEntryNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.hashNode = new HashNode(context, sourceSection);
        this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context);
        this.equalNode = BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(null);
    }

    public HashLookupResult lookup(VirtualFrame frame, DynamicObject hash, Object key) {
        int hashed = this.hashNode.hash(frame, key);
        Entry[] entries = (Entry[])Layouts.HASH.getStore(hash);
        int index = BucketsStrategy.getBucketIndex(hashed, entries.length);
        Entry previousEntry = null;
        for (Entry entry = entries[index]; entry != null; entry = entry.getNextInLookup()) {
            if (this.byIdentityProfile.profile(Layouts.HASH.getCompareByIdentity(hash)) ? this.equalNode.executeReferenceEqual(frame, key, entry.getKey()) : this.eqlNode.callBoolean(frame, key, "eql?", null, entry.getKey())) {
                return new HashLookupResult(hashed, index, previousEntry, entry);
            }
            previousEntry = entry;
        }
        return new HashLookupResult(hashed, index, previousEntry, null);
    }
}

