/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.dispatch.DoesRespondDispatchHeadNode;
import org.jruby.truffle.language.objects.WriteObjectFieldNode;
import org.jruby.truffle.language.objects.WriteObjectFieldNodeGen;

@NodeChildren(value={@NodeChild(value="receiver"), @NodeChild(value="name"), @NodeChild(value="stringName"), @NodeChild(value="isIVar"), @NodeChild(value="value")})
abstract class ForeignWriteStringCachedHelperNode
extends RubyNode {
    @Node.Child
    private DoesRespondDispatchHeadNode definedNode;
    @Node.Child
    private DoesRespondDispatchHeadNode indexDefinedNode;
    @Node.Child
    private CallDispatchHeadNode callNode;
    protected static final String INDEX_SET_METHOD_NAME = "[]=";

    ForeignWriteStringCachedHelperNode() {
    }

    public abstract Object executeStringCachedHelper(VirtualFrame var1, DynamicObject var2, Object var3, Object var4, boolean var5, Object var6);

    @Specialization(guards={"isIVar"})
    public Object readInstanceVariable(DynamicObject receiver, Object name, Object stringName, boolean isIVar, Object value, @Cached(value="createWriteObjectFieldNode(stringName)") WriteObjectFieldNode writeObjectFieldNode) {
        writeObjectFieldNode.execute(receiver, value);
        return value;
    }

    protected WriteObjectFieldNode createWriteObjectFieldNode(Object name) {
        return WriteObjectFieldNodeGen.create(name);
    }

    @Specialization(guards={"not(isIVar)", "methodDefined(frame, receiver, writeMethodName, getDefinedNode())"})
    public Object callMethod(VirtualFrame frame, DynamicObject receiver, Object name, Object stringName, boolean isIVar, Object value, @Cached(value="createWriteMethodName(stringName)") String writeMethodName) {
        return this.getCallNode().call(frame, receiver, writeMethodName, null, value);
    }

    protected boolean not(boolean value) {
        return !value;
    }

    protected String createWriteMethodName(Object name) {
        return name + "=";
    }

    @Specialization(guards={"!isIVar", "!methodDefined(frame, receiver, writeMethodName, getDefinedNode())", "methodDefined(frame, receiver, INDEX_SET_METHOD_NAME, getIndexDefinedNode())"})
    public Object index(VirtualFrame frame, DynamicObject receiver, Object name, Object stringName, boolean isIVar, Object value, @Cached(value="createWriteMethodName(stringName)") String writeMethodName) {
        return this.getCallNode().call(frame, receiver, INDEX_SET_METHOD_NAME, null, name, value);
    }

    protected DoesRespondDispatchHeadNode getDefinedNode() {
        if (this.definedNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.definedNode = this.insert(new DoesRespondDispatchHeadNode(this.getContext(), true));
        }
        return this.definedNode;
    }

    protected DoesRespondDispatchHeadNode getIndexDefinedNode() {
        if (this.indexDefinedNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.indexDefinedNode = this.insert(new DoesRespondDispatchHeadNode(this.getContext(), true));
        }
        return this.indexDefinedNode;
    }

    protected boolean methodDefined(VirtualFrame frame, DynamicObject receiver, Object stringName, DoesRespondDispatchHeadNode definedNode) {
        if (stringName == null) {
            return false;
        }
        return definedNode.doesRespondTo(frame, stringName, receiver);
    }

    protected CallDispatchHeadNode getCallNode() {
        if (this.callNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.callNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
        }
        return this.callNode;
    }
}

