/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKt;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignature;
import org.jetbrains.kotlin.resolve.calls.results.SpecificityComparisonCallbacks;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a:\u0010\u0005\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00062\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00072\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\u00a8\u0006\u000f"}, d2={"isDefinitelyLessSpecificByTypeSpecificity", "", "specific", "Lorg/jetbrains/kotlin/types/KotlinType;", "general", "isSignatureNotLessSpecific", "T", "Lorg/jetbrains/kotlin/resolve/calls/results/FlatSignature;", "callbacks", "Lorg/jetbrains/kotlin/resolve/calls/results/SpecificityComparisonCallbacks;", "callHandle", "Lorg/jetbrains/kotlin/resolve/calls/inference/CallHandle;", "getSpecificityRelationTo", "Lorg/jetbrains/kotlin/types/Flexibility$SpecificityRelation;", "otherType", "kotlin-compiler"})
public final class FlatSignatureSpecificityKt {
    public static final <T> boolean isSignatureNotLessSpecific(@NotNull FlatSignature<? extends T> specific, @NotNull FlatSignature<? extends T> general, @NotNull SpecificityComparisonCallbacks callbacks, @NotNull CallHandle callHandle) {
        Intrinsics.checkParameterIsNotNull(specific, "specific");
        Intrinsics.checkParameterIsNotNull(general, "general");
        Intrinsics.checkParameterIsNotNull(callbacks, "callbacks");
        Intrinsics.checkParameterIsNotNull(callHandle, "callHandle");
        if (specific.getHasExtensionReceiver() != general.getHasExtensionReceiver()) {
            return false;
        }
        if (specific.getValueParameterTypes().size() != general.getValueParameterTypes().size()) {
            return false;
        }
        Collection<TypeParameterDescriptor> typeParameters = general.getTypeParameters();
        ConstraintSystem.Builder constraintSystemBuilder = ConstraintSystemBuilderImpl.Companion.forSpecificity();
        TypeSubstitutor typeSubstitutor2 = ConstraintSystem.Builder.DefaultImpls.registerTypeVariables$default(constraintSystemBuilder, callHandle, typeParameters, false, 4, null);
        int numConstraints = 0;
        for (Pair pair : CollectionsKt.zip((Iterable)specific.getValueParameterTypes(), (Iterable)general.getValueParameterTypes())) {
            KotlinType specificType = (KotlinType)pair.component1();
            KotlinType generalType = (KotlinType)pair.component2();
            if (specificType == null || generalType == null) continue;
            if (FlatSignatureSpecificityKt.isDefinitelyLessSpecificByTypeSpecificity(specificType, generalType)) {
                return false;
            }
            if (typeParameters.isEmpty() || !TypeUtils.dependsOnTypeParameters(generalType, typeParameters)) {
                if (KotlinTypeChecker.DEFAULT.isSubtypeOf(specificType, generalType) || callbacks.isNonSubtypeNotLessSpecific(specificType, generalType)) continue;
                return false;
            }
            KotlinType substitutedGeneralType = typeSubstitutor2.safeSubstitute(generalType, Variance.INVARIANT);
            constraintSystemBuilder.addSubtypeConstraint(specificType, substitutedGeneralType, ConstraintPositionKt.valueParameterPosition(numConstraints++));
        }
        constraintSystemBuilder.fixVariables();
        ConstraintSystem constraintSystem = constraintSystemBuilder.build();
        return !constraintSystem.getStatus().hasContradiction();
    }

    public static /* bridge */ /* synthetic */ boolean isSignatureNotLessSpecific$default(FlatSignature flatSignature, FlatSignature flatSignature2, SpecificityComparisonCallbacks specificityComparisonCallbacks, CallHandle callHandle, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isSignatureNotLessSpecific");
        }
        if ((n & 8) != 0) {
            callHandle = CallHandle.NONE.INSTANCE;
        }
        return FlatSignatureSpecificityKt.isSignatureNotLessSpecific(flatSignature, flatSignature2, specificityComparisonCallbacks, callHandle);
    }

    private static final Flexibility.SpecificityRelation getSpecificityRelationTo(@NotNull KotlinType $receiver, KotlinType otherType) {
        Object object = $receiver.getCapability(Flexibility.class);
        if (object == null || (object = object.getSpecificityRelationTo(otherType)) == null) {
            object = Flexibility.SpecificityRelation.DONT_KNOW;
        }
        return object;
    }

    private static final boolean isDefinitelyLessSpecificByTypeSpecificity(KotlinType specific, KotlinType general) {
        Flexibility.SpecificityRelation sThanG = FlatSignatureSpecificityKt.getSpecificityRelationTo(specific, general);
        Flexibility.SpecificityRelation gThanS = FlatSignatureSpecificityKt.getSpecificityRelationTo(general, specific);
        return Intrinsics.areEqual((Object)sThanG, (Object)Flexibility.SpecificityRelation.LESS_SPECIFIC) && Intrinsics.areEqual((Object)gThanS, (Object)Flexibility.SpecificityRelation.LESS_SPECIFIC) ^ true;
    }
}

