/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree3d;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.bkdtree3d.BKD3DTreeReader;
import org.apache.lucene.bkdtree3d.Geo3DBinaryDocValues;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

@Deprecated
class Geo3DDocValuesProducer
extends DocValuesProducer {
    private final Map<String, BKD3DTreeReader> treeReaders = new HashMap<String, BKD3DTreeReader>();
    private final Map<Integer, Long> fieldToIndexFPs = new HashMap<Integer, Long>();
    private final IndexInput datIn;
    private final AtomicLong ramBytesUsed;
    private final int maxDoc;
    private final DocValuesProducer delegate;
    private final boolean merging;
    private final double planetMax;

    public Geo3DDocValuesProducer(DocValuesProducer delegate, SegmentReadState state) throws IOException {
        String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"g3dm");
        ChecksumIndexInput metaIn = state.directory.openChecksumInput(metaFileName, state.context);
        CodecUtil.checkIndexHeader((DataInput)metaIn, (String)"Geo3DMeta", (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
        int fieldCount = metaIn.readVInt();
        for (int i = 0; i < fieldCount; ++i) {
            int fieldNumber = metaIn.readVInt();
            long indexFP = metaIn.readVLong();
            this.fieldToIndexFPs.put(fieldNumber, indexFP);
        }
        CodecUtil.checkFooter((ChecksumIndexInput)metaIn);
        metaIn.close();
        String datFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"g3dd");
        this.datIn = state.directory.openInput(datFileName, state.context);
        CodecUtil.checkIndexHeader((DataInput)this.datIn, (String)"Geo3DData", (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
        this.planetMax = Double.longBitsToDouble(this.datIn.readLong());
        this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(((Object)((Object)this)).getClass()));
        this.maxDoc = state.segmentInfo.maxDoc();
        this.delegate = delegate;
        this.merging = false;
    }

    Geo3DDocValuesProducer(Geo3DDocValuesProducer orig) throws IOException {
        assert (Thread.holdsLock((Object)orig));
        this.datIn = orig.datIn.clone();
        this.ramBytesUsed = new AtomicLong(orig.ramBytesUsed.get());
        this.delegate = orig.delegate.getMergeInstance();
        this.fieldToIndexFPs.putAll(orig.fieldToIndexFPs);
        this.treeReaders.putAll(orig.treeReaders);
        this.merging = true;
        this.maxDoc = orig.maxDoc;
        this.planetMax = orig.planetMax;
    }

    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.datIn, this.delegate});
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.datIn);
    }

    public NumericDocValues getNumeric(FieldInfo field) {
        throw new UnsupportedOperationException();
    }

    public synchronized BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BKD3DTreeReader treeReader = this.treeReaders.get(field.name);
        if (treeReader == null) {
            Long fp = this.fieldToIndexFPs.get(field.number);
            if (fp == null) {
                throw new IllegalArgumentException("this field was not indexed as a BKDPointField");
            }
            IndexInput clone = this.datIn.clone();
            clone.seek(fp.longValue());
            treeReader = new BKD3DTreeReader(clone, this.maxDoc);
            if (!this.merging) {
                this.treeReaders.put(field.name, treeReader);
                this.ramBytesUsed.addAndGet(treeReader.ramBytesUsed());
            }
        }
        return new Geo3DBinaryDocValues(treeReader, this.delegate.getBinary(field), this.planetMax);
    }

    public SortedDocValues getSorted(FieldInfo field) {
        throw new UnsupportedOperationException();
    }

    public SortedSetDocValues getSortedSet(FieldInfo field) {
        throw new UnsupportedOperationException();
    }

    public Bits getDocsWithField(FieldInfo field) throws IOException {
        return this.delegate.getDocsWithField(field);
    }

    public synchronized Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        for (Map.Entry<String, BKD3DTreeReader> ent : this.treeReaders.entrySet()) {
            resources.add(Accountables.namedAccountable((String)("field " + ent.getKey()), (Accountable)ent.getValue()));
        }
        resources.add(Accountables.namedAccountable((String)"delegate", (Accountable)this.delegate));
        return resources;
    }

    public synchronized DocValuesProducer getMergeInstance() throws IOException {
        return new Geo3DDocValuesProducer(this);
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed.get() + this.delegate.ramBytesUsed();
    }
}

