/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;

public class RoutingNode
implements Iterable<ShardRouting> {
    private final String nodeId;
    private final DiscoveryNode node;
    private final List<ShardRouting> shards;

    public RoutingNode(String nodeId, DiscoveryNode node) {
        this(nodeId, node, new ArrayList<ShardRouting>());
    }

    public RoutingNode(String nodeId, DiscoveryNode node, List<ShardRouting> shards) {
        this.nodeId = nodeId;
        this.node = node;
        this.shards = shards;
    }

    @Override
    public Iterator<ShardRouting> iterator() {
        return Iterators.unmodifiableIterator(this.shards.iterator());
    }

    Iterator<ShardRouting> mutableIterator() {
        return this.shards.iterator();
    }

    public DiscoveryNode node() {
        return this.node;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public int size() {
        return this.shards.size();
    }

    void add(ShardRouting shard) {
        for (ShardRouting shardRouting : this.shards) {
            if (!shardRouting.isSameShard(shard)) continue;
            throw new IllegalStateException("Trying to add a shard [" + shard.shardId().index().name() + "][" + shard.shardId().id() + "] to a node [" + this.nodeId + "] where it already exists");
        }
        this.shards.add(shard);
    }

    public int numberOfShardsWithState(ShardRoutingState ... states) {
        int count = 0;
        for (ShardRouting shardEntry : this) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                ++count;
            }
        }
        return count;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState ... states) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (ShardRouting shardEntry : this) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public List<ShardRouting> shardsWithState(String index, ShardRoutingState ... states) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (ShardRouting shardEntry : this) {
            if (!shardEntry.index().equals(index)) continue;
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public int numberOfOwningShards() {
        int count = 0;
        for (ShardRouting shardEntry : this) {
            if (shardEntry.state() == ShardRoutingState.RELOCATING) continue;
            ++count;
        }
        return count;
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("-----node_id[").append(this.nodeId).append("][" + (this.node == null ? "X" : "V") + "]\n");
        for (ShardRouting entry : this.shards) {
            sb.append("--------").append(entry.shortSummary()).append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("routingNode ([");
        sb.append(this.node.getName());
        sb.append("][");
        sb.append(this.node.getId());
        sb.append("][");
        sb.append(this.node.getHostName());
        sb.append("][");
        sb.append(this.node.getHostAddress());
        sb.append("], [");
        sb.append(this.shards.size());
        sb.append(" assigned shards])");
        return sb.toString();
    }

    public ShardRouting get(int i) {
        return this.shards.get(i);
    }

    public Collection<ShardRouting> copyShards() {
        return new ArrayList<ShardRouting>(this.shards);
    }

    public boolean isEmpty() {
        return this.shards.isEmpty();
    }
}

