/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.http.client;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.List;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.Build;
import org.elasticsearch.ElasticsearchCorruptionException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.unit.TimeValue;

public class HttpDownloadHelper {
    private boolean useTimestamp = false;
    private boolean skipExisting = false;
    public static Checksummer SHA1_CHECKSUM = new Checksummer(){

        @Override
        public String checksum(byte[] filebytes) {
            return MessageDigests.toHexString(MessageDigests.sha1().digest(filebytes));
        }

        @Override
        public String name() {
            return "SHA1";
        }
    };
    public static Checksummer MD5_CHECKSUM = new Checksummer(){

        @Override
        public String checksum(byte[] filebytes) {
            return MessageDigests.toHexString(MessageDigests.md5().digest(filebytes));
        }

        @Override
        public String name() {
            return "MD5";
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download(URL source, Path dest, @Nullable DownloadProgress progress, TimeValue timeout) throws Exception {
        if (Files.exists(dest, new LinkOption[0]) && this.skipExisting) {
            return true;
        }
        if (progress == null) {
            progress = new NullProgress();
        }
        long timestamp = 0L;
        boolean hasTimestamp = false;
        if (this.useTimestamp && Files.exists(dest, new LinkOption[0])) {
            timestamp = Files.getLastModifiedTime(dest, new LinkOption[0]).toMillis();
            hasTimestamp = true;
        }
        GetThread getThread = new GetThread(source, dest, hasTimestamp, timestamp, progress);
        try {
            getThread.setDaemon(true);
            getThread.start();
            getThread.join(timeout.millis());
            if (getThread.isAlive()) {
                throw new ElasticsearchTimeoutException("The GET operation took longer than " + timeout + ", stopping it.", new Object[0]);
            }
        }
        catch (InterruptedException ie) {
            boolean bl = false;
            return bl;
        }
        finally {
            getThread.closeStreams();
        }
        return getThread.wasSuccessful();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadAndVerifyChecksum(URL checksumURL, Path originalFile, Path checksumFile, @Nullable DownloadProgress progress, TimeValue timeout, Checksummer hashFunc) throws Exception {
        block6: {
            boolean bl;
            try {
                if (!this.download(checksumURL, checksumFile, progress, timeout)) break block6;
                byte[] fileBytes = Files.readAllBytes(originalFile);
                List<String> checksumLines = Files.readAllLines(checksumFile, StandardCharsets.UTF_8);
                if (checksumLines.size() != 1) {
                    throw new ElasticsearchCorruptionException("invalid format for checksum file (" + hashFunc.name() + "), expected 1 line, got: " + checksumLines.size());
                }
                String checksumHex = checksumLines.get(0);
                String fileHex = hashFunc.checksum(fileBytes);
                if (!fileHex.equals(checksumHex)) {
                    throw new ElasticsearchCorruptionException("incorrect hash (" + hashFunc.name() + "), file hash: [" + fileHex + "], expected: [" + checksumHex + "]");
                }
                bl = true;
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                boolean bl2;
                try {
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{checksumFile});
                    throw throwable;
                }
                IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{checksumFile});
                return bl2;
            }
            IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{checksumFile});
            return bl;
        }
        IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{checksumFile});
        return false;
    }

    private class GetThread
    extends Thread {
        private final URL source;
        private final Path dest;
        private final boolean hasTimestamp;
        private final long timestamp;
        private final DownloadProgress progress;
        private boolean success = false;
        private IOException ioexception = null;
        private InputStream is = null;
        private OutputStream os = null;
        private URLConnection connection;
        private int redirections = 0;

        GetThread(URL source, Path dest, boolean h, long t, DownloadProgress p) {
            this.source = source;
            this.dest = dest;
            this.hasTimestamp = h;
            this.timestamp = t;
            this.progress = p;
        }

        @Override
        public void run() {
            try {
                this.success = this.get();
            }
            catch (IOException ioex) {
                this.ioexception = ioex;
            }
        }

        private boolean get() throws IOException {
            this.connection = this.openConnection(this.source);
            if (this.connection == null) {
                return false;
            }
            boolean downloadSucceeded = this.downloadFile();
            if (downloadSucceeded && HttpDownloadHelper.this.useTimestamp) {
                this.updateTimeStamp();
            }
            return downloadSucceeded;
        }

        private boolean redirectionAllowed(URL aSource, URL aDest) throws IOException {
            ++this.redirections;
            if (this.redirections > 5) {
                String message = "More than 5 times redirected, giving up";
                throw new IOException(message);
            }
            return true;
        }

        private URLConnection openConnection(URL aSource) throws IOException {
            boolean isAuthInfoSet;
            URLConnection connection = aSource.openConnection();
            if (this.hasTimestamp) {
                connection.setIfModifiedSince(this.timestamp);
            }
            boolean isSecureProcotol = "https".equalsIgnoreCase(aSource.getProtocol());
            boolean bl = isAuthInfoSet = !Strings.isNullOrEmpty(aSource.getUserInfo());
            if (isAuthInfoSet) {
                if (!isSecureProcotol) {
                    throw new IOException("Basic auth is only supported for HTTPS!");
                }
                String basicAuth = Base64.encodeBytes(aSource.getUserInfo().getBytes(StandardCharsets.UTF_8));
                connection.setRequestProperty("Authorization", "Basic " + basicAuth);
            }
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setInstanceFollowRedirects(false);
                connection.setUseCaches(true);
                connection.setConnectTimeout(5000);
            }
            connection.setRequestProperty("ES-Version", Version.CURRENT.toString());
            connection.setRequestProperty("ES-Build-Hash", Build.CURRENT.hashShort());
            connection.setRequestProperty("User-Agent", "elasticsearch-plugin-manager");
            connection.connect();
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                int responseCode = httpConnection.getResponseCode();
                if (responseCode == 301 || responseCode == 302 || responseCode == 303) {
                    String newLocation = httpConnection.getHeaderField("Location");
                    URL newURL = new URL(newLocation);
                    if (!this.redirectionAllowed(aSource, newURL)) {
                        return null;
                    }
                    return this.openConnection(newURL);
                }
                long lastModified = httpConnection.getLastModified();
                if (responseCode == 304 || lastModified != 0L && this.hasTimestamp && this.timestamp >= lastModified) {
                    return null;
                }
                if (responseCode == 401) {
                    String message = "HTTP Authorization failure";
                    throw new IOException(message);
                }
            }
            return connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean downloadFile() throws FileNotFoundException, IOException {
            block10: {
                block9: {
                    IOException lastEx = null;
                    for (int i = 0; i < 3; ++i) {
                        try {
                            this.is = this.connection.getInputStream();
                            break;
                        }
                        catch (IOException ex) {
                            lastEx = ex;
                            continue;
                        }
                    }
                    if (this.is == null) {
                        throw lastEx;
                    }
                    this.os = Files.newOutputStream(this.dest, new OpenOption[0]);
                    this.progress.beginDownload();
                    boolean finished = false;
                    try {
                        int length;
                        byte[] buffer = new byte[102400];
                        while (!this.isInterrupted() && (length = this.is.read(buffer)) >= 0) {
                            this.os.write(buffer, 0, length);
                            this.progress.onTick();
                        }
                        boolean bl = finished = !this.isInterrupted();
                        if (finished) break block9;
                    }
                    catch (Throwable throwable) {
                        if (!finished) {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.os, this.is});
                            IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{this.dest});
                        } else {
                            IOUtils.close((Closeable[])new Closeable[]{this.os, this.is});
                        }
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.os, this.is});
                    IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{this.dest});
                    break block10;
                }
                IOUtils.close((Closeable[])new Closeable[]{this.os, this.is});
            }
            this.progress.endDownload();
            return true;
        }

        private void updateTimeStamp() throws IOException {
            long remoteTimestamp = this.connection.getLastModified();
            if (remoteTimestamp != 0L) {
                Files.setLastModifiedTime(this.dest, FileTime.fromMillis(remoteTimestamp));
            }
        }

        boolean wasSuccessful() throws IOException {
            if (this.ioexception != null) {
                throw this.ioexception;
            }
            return this.success;
        }

        void closeStreams() throws IOException {
            this.interrupt();
            if (this.success) {
                IOUtils.close((Closeable[])new Closeable[]{this.is, this.os});
            } else {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.is, this.os});
                if (this.dest != null && Files.exists(this.dest, new LinkOption[0])) {
                    IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{this.dest});
                }
            }
        }
    }

    public static class VerboseProgress
    implements DownloadProgress {
        private int dots = 0;
        PrintWriter writer;

        public VerboseProgress(PrintWriter writer) {
            this.writer = writer;
        }

        @Override
        public void beginDownload() {
            this.writer.print("Downloading ");
            this.dots = 0;
        }

        @Override
        public void onTick() {
            this.writer.print(".");
            if (this.dots++ > 50) {
                this.writer.flush();
                this.dots = 0;
            }
        }

        @Override
        public void endDownload() {
            this.writer.println("DONE");
            this.writer.flush();
        }
    }

    public static class NullProgress
    implements DownloadProgress {
        @Override
        public void beginDownload() {
        }

        @Override
        public void onTick() {
        }

        @Override
        public void endDownload() {
        }
    }

    public static interface DownloadProgress {
        public void beginDownload();

        public void onTick();

        public void endDownload();
    }

    public static interface Checksummer {
        public String checksum(byte[] var1);

        public String name();
    }
}

