/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.util.Bits;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;

final class SingletonMultiGeoPointValues
extends MultiGeoPointValues {
    private final GeoPointValues in;
    private final Bits docsWithField;
    private GeoPoint value;
    private int count;

    SingletonMultiGeoPointValues(GeoPointValues in, Bits docsWithField) {
        this.in = in;
        this.docsWithField = docsWithField;
    }

    @Override
    public void setDocument(int docID) {
        this.value = this.in.get(docID);
        this.count = this.value.lat() == Double.NaN && this.value.lon() == Double.NaN || this.docsWithField != null && !this.docsWithField.get(docID) ? 0 : 1;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public GeoPoint valueAt(int index) {
        assert (index == 0);
        return this.value;
    }

    public GeoPointValues getGeoPointValues() {
        return this.in;
    }

    public Bits getDocsWithField() {
        return this.docsWithField;
    }
}

