/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.suggest;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.suggest.SuggestRequest;
import org.elasticsearch.action.suggest.SuggestResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.search.suggest.Suggest;

public class RestSuggestAction
extends BaseRestHandler {
    @Inject
    public RestSuggestAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.POST, "/_suggest", this);
        controller.registerHandler(RestRequest.Method.GET, "/_suggest", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_suggest", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_suggest", this);
    }

    @Override
    public void handleRequest(final RestRequest request, RestChannel channel, Client client) {
        SuggestRequest suggestRequest = new SuggestRequest(Strings.splitStringByCommaToArray(request.param("index")));
        suggestRequest.indicesOptions(IndicesOptions.fromRequest(request, suggestRequest.indicesOptions()));
        if (!RestActions.hasBodyContent(request)) {
            throw new IllegalArgumentException("no content or source provided to execute suggestion");
        }
        suggestRequest.suggest(RestActions.getRestContent(request));
        suggestRequest.routing(request.param("routing"));
        suggestRequest.preference(request.param("preference"));
        client.suggest(suggestRequest, (ActionListener<SuggestResponse>)new RestBuilderListener<SuggestResponse>(channel){

            @Override
            public RestResponse buildResponse(SuggestResponse response, XContentBuilder builder) throws Exception {
                RestStatus restStatus = RestStatus.status(response.getSuccessfulShards(), response.getTotalShards(), response.getShardFailures());
                builder.startObject();
                RestActions.buildBroadcastShardsHeader(builder, request, response);
                Suggest suggest = response.getSuggest();
                if (suggest != null) {
                    suggest.toXContent(builder, request);
                }
                builder.endObject();
                return new BytesRestResponse(restStatus, builder);
            }
        });
    }
}

