/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.DelegatingHasContextAndHeaders;
import org.elasticsearch.common.HasContextAndHeaders;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorStreams;
import org.elasticsearch.search.aggregations.support.AggregationPath;

public abstract class InternalAggregation
implements Aggregation,
ToXContent,
Streamable {
    protected String name;
    protected Map<String, Object> metaData;
    private List<PipelineAggregator> pipelineAggregators;

    protected InternalAggregation() {
    }

    protected InternalAggregation(String name, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        this.name = name;
        this.pipelineAggregators = pipelineAggregators;
        this.metaData = metaData;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public abstract Type type();

    public final InternalAggregation reduce(List<InternalAggregation> aggregations, ReduceContext reduceContext) {
        InternalAggregation aggResult = this.doReduce(aggregations, reduceContext);
        for (PipelineAggregator pipelineAggregator : this.pipelineAggregators) {
            aggResult = pipelineAggregator.reduce(aggResult, reduceContext);
        }
        return aggResult;
    }

    public abstract InternalAggregation doReduce(List<InternalAggregation> var1, ReduceContext var2);

    @Override
    public Object getProperty(String path) {
        AggregationPath aggPath = AggregationPath.parse(path);
        return this.getProperty(aggPath.getPathElementsAsStringList());
    }

    public abstract Object getProperty(List<String> var1);

    protected static int readSize(StreamInput in) throws IOException {
        int size = in.readVInt();
        return size == 0 ? Integer.MAX_VALUE : size;
    }

    protected static void writeSize(int size, StreamOutput out) throws IOException {
        if (size == Integer.MAX_VALUE) {
            size = 0;
        }
        out.writeVInt(size);
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public List<PipelineAggregator> pipelineAggregators() {
        return this.pipelineAggregators;
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        if (this.metaData != null) {
            builder.field(CommonFields.META);
            builder.map(this.metaData);
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeGenericValue(this.metaData);
        out.writeVInt(this.pipelineAggregators.size());
        for (PipelineAggregator pipelineAggregator : this.pipelineAggregators) {
            out.writeBytesReference(pipelineAggregator.type().stream());
            pipelineAggregator.writeTo(out);
        }
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    @Override
    public final void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.metaData = in.readMap();
        int size = in.readVInt();
        if (size == 0) {
            this.pipelineAggregators = Collections.emptyList();
        } else {
            this.pipelineAggregators = new ArrayList<PipelineAggregator>(size);
            for (int i = 0; i < size; ++i) {
                BytesReference type = in.readBytesReference();
                PipelineAggregator pipelineAggregator = PipelineAggregatorStreams.stream(type).readResult(in);
                this.pipelineAggregators.add(pipelineAggregator);
            }
        }
        this.doReadFrom(in);
    }

    protected abstract void doReadFrom(StreamInput var1) throws IOException;

    public static final class CommonFields {
        public static final XContentBuilderString META = new XContentBuilderString("meta");
        public static final XContentBuilderString BUCKETS = new XContentBuilderString("buckets");
        public static final XContentBuilderString VALUE = new XContentBuilderString("value");
        public static final XContentBuilderString VALUES = new XContentBuilderString("values");
        public static final XContentBuilderString VALUE_AS_STRING = new XContentBuilderString("value_as_string");
        public static final XContentBuilderString DOC_COUNT = new XContentBuilderString("doc_count");
        public static final XContentBuilderString KEY = new XContentBuilderString("key");
        public static final XContentBuilderString KEY_AS_STRING = new XContentBuilderString("key_as_string");
        public static final XContentBuilderString FROM = new XContentBuilderString("from");
        public static final XContentBuilderString FROM_AS_STRING = new XContentBuilderString("from_as_string");
        public static final XContentBuilderString TO = new XContentBuilderString("to");
        public static final XContentBuilderString TO_AS_STRING = new XContentBuilderString("to_as_string");
    }

    public static class ReduceContext
    extends DelegatingHasContextAndHeaders {
        private final BigArrays bigArrays;
        private ScriptService scriptService;

        public ReduceContext(BigArrays bigArrays, ScriptService scriptService, HasContextAndHeaders headersContext) {
            super(headersContext);
            this.bigArrays = bigArrays;
            this.scriptService = scriptService;
        }

        public BigArrays bigArrays() {
            return this.bigArrays;
        }

        public ScriptService scriptService() {
            return this.scriptService;
        }
    }

    public static class Type {
        private String name;
        private BytesReference stream;

        public Type(String name) {
            this(name, new BytesArray(name));
        }

        public Type(String name, String stream) {
            this(name, new BytesArray(stream));
        }

        public Type(String name, BytesReference stream) {
            this.name = name;
            this.stream = stream;
        }

        public String name() {
            return this.name;
        }

        public BytesReference stream() {
            return this.stream;
        }

        public String toString() {
            return this.name;
        }
    }
}

