/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.builder;

import com.carrotsearch.hppc.ObjectFloatHashMap;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.fetch.innerhits.InnerHitsBuilder;
import org.elasticsearch.search.fetch.source.FetchSourceContext;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.elasticsearch.search.rescore.RescoreBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilder;

public class SearchSourceBuilder
extends ToXContentToBytes {
    private QuerySourceBuilder querySourceBuilder;
    private QueryBuilder postQueryBuilder;
    private BytesReference filterBinary;
    private int from = -1;
    private int size = -1;
    private Boolean explain;
    private Boolean version;
    private List<SortBuilder> sorts;
    private boolean trackScores = false;
    private Float minScore;
    private long timeoutInMillis = -1L;
    private int terminateAfter = 0;
    private List<String> fieldNames;
    private List<String> fieldDataFields;
    private List<ScriptField> scriptFields;
    private FetchSourceContext fetchSourceContext;
    private List<AbstractAggregationBuilder> aggregations;
    private BytesReference aggregationsBinary;
    private HighlightBuilder highlightBuilder;
    private SuggestBuilder suggestBuilder;
    private InnerHitsBuilder innerHitsBuilder;
    private List<RescoreBuilder> rescoreBuilders;
    private Integer defaultRescoreWindowSize;
    private ObjectFloatHashMap<String> indexBoost = null;
    private String[] stats;
    private boolean profile = false;

    public static SearchSourceBuilder searchSource() {
        return new SearchSourceBuilder();
    }

    public static HighlightBuilder highlight() {
        return new HighlightBuilder();
    }

    public SearchSourceBuilder query(QuerySourceBuilder querySourceBuilder) {
        this.querySourceBuilder = querySourceBuilder;
        return this;
    }

    public SearchSourceBuilder query(QueryBuilder query) {
        if (this.querySourceBuilder == null) {
            this.querySourceBuilder = new QuerySourceBuilder();
        }
        this.querySourceBuilder.setQuery(query);
        return this;
    }

    public SearchSourceBuilder query(byte[] queryBinary) {
        return this.query(queryBinary, 0, queryBinary.length);
    }

    public SearchSourceBuilder query(byte[] queryBinary, int queryBinaryOffset, int queryBinaryLength) {
        return this.query(new BytesArray(queryBinary, queryBinaryOffset, queryBinaryLength));
    }

    public SearchSourceBuilder query(BytesReference queryBinary) {
        if (this.querySourceBuilder == null) {
            this.querySourceBuilder = new QuerySourceBuilder();
        }
        this.querySourceBuilder.setQuery(queryBinary);
        return this;
    }

    public SearchSourceBuilder query(String queryString) {
        return this.query(queryString.getBytes(Charsets.UTF_8));
    }

    public SearchSourceBuilder query(XContentBuilder query) {
        return this.query(query.bytes());
    }

    public SearchSourceBuilder query(Map query) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(query);
            return this.query(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + query + "]", e);
        }
    }

    public SearchSourceBuilder postFilter(QueryBuilder postFilter) {
        this.postQueryBuilder = postFilter;
        return this;
    }

    public SearchSourceBuilder postFilter(String postFilterString) {
        return this.postFilter(postFilterString.getBytes(Charsets.UTF_8));
    }

    public SearchSourceBuilder postFilter(byte[] postFilter) {
        return this.postFilter(postFilter, 0, postFilter.length);
    }

    public SearchSourceBuilder postFilter(byte[] postFilterBinary, int postFilterBinaryOffset, int postFilterBinaryLength) {
        return this.postFilter(new BytesArray(postFilterBinary, postFilterBinaryOffset, postFilterBinaryLength));
    }

    public SearchSourceBuilder postFilter(BytesReference postFilterBinary) {
        this.filterBinary = postFilterBinary;
        return this;
    }

    public SearchSourceBuilder postFilter(XContentBuilder postFilter) {
        return this.postFilter(postFilter.bytes());
    }

    public SearchSourceBuilder postFilter(Map postFilter) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(postFilter);
            return this.postFilter(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + postFilter + "]", e);
        }
    }

    public SearchSourceBuilder from(int from) {
        this.from = from;
        return this;
    }

    public SearchSourceBuilder size(int size) {
        this.size = size;
        return this;
    }

    public SearchSourceBuilder minScore(float minScore) {
        this.minScore = Float.valueOf(minScore);
        return this;
    }

    public SearchSourceBuilder explain(Boolean explain) {
        this.explain = explain;
        return this;
    }

    public SearchSourceBuilder version(Boolean version) {
        this.version = version;
        return this;
    }

    public SearchSourceBuilder timeout(TimeValue timeout) {
        this.timeoutInMillis = timeout.millis();
        return this;
    }

    public SearchSourceBuilder timeout(String timeout) {
        this.timeoutInMillis = TimeValue.parseTimeValue(timeout, null, this.getClass().getSimpleName() + ".timeout").millis();
        return this;
    }

    public SearchSourceBuilder terminateAfter(int terminateAfter) {
        if (terminateAfter <= 0) {
            throw new IllegalArgumentException("terminateAfter must be > 0");
        }
        this.terminateAfter = terminateAfter;
        return this;
    }

    public SearchSourceBuilder sort(String name, SortOrder order) {
        return this.sort(SortBuilders.fieldSort(name).order(order));
    }

    public SearchSourceBuilder sort(String name) {
        return this.sort(SortBuilders.fieldSort(name));
    }

    public SearchSourceBuilder sort(SortBuilder sort) {
        if (this.sorts == null) {
            this.sorts = new ArrayList<SortBuilder>();
        }
        this.sorts.add(sort);
        return this;
    }

    public SearchSourceBuilder trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    public SearchSourceBuilder aggregation(AbstractAggregationBuilder aggregation) {
        if (this.aggregations == null) {
            this.aggregations = new ArrayList<AbstractAggregationBuilder>();
        }
        this.aggregations.add(aggregation);
        return this;
    }

    public SearchSourceBuilder aggregations(byte[] aggregationsBinary) {
        return this.aggregations(aggregationsBinary, 0, aggregationsBinary.length);
    }

    public SearchSourceBuilder aggregations(byte[] aggregationsBinary, int aggregationsBinaryOffset, int aggregationsBinaryLength) {
        return this.aggregations(new BytesArray(aggregationsBinary, aggregationsBinaryOffset, aggregationsBinaryLength));
    }

    public SearchSourceBuilder aggregations(BytesReference aggregationsBinary) {
        this.aggregationsBinary = aggregationsBinary;
        return this;
    }

    public SearchSourceBuilder aggregations(XContentBuilder aggs) {
        return this.aggregations(aggs.bytes());
    }

    @Deprecated
    public SearchSourceBuilder defaultRescoreWindowSize(int defaultRescoreWindowSize) {
        this.defaultRescoreWindowSize = defaultRescoreWindowSize;
        return this;
    }

    public SearchSourceBuilder aggregations(Map aggregations) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(aggregations);
            return this.aggregations(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + aggregations + "]", e);
        }
    }

    public HighlightBuilder highlighter() {
        if (this.highlightBuilder == null) {
            this.highlightBuilder = new HighlightBuilder();
        }
        return this.highlightBuilder;
    }

    public SearchSourceBuilder highlight(HighlightBuilder highlightBuilder) {
        this.highlightBuilder = highlightBuilder;
        return this;
    }

    public InnerHitsBuilder innerHitsBuilder() {
        if (this.innerHitsBuilder == null) {
            this.innerHitsBuilder = new InnerHitsBuilder();
        }
        return this.innerHitsBuilder;
    }

    public SuggestBuilder suggest() {
        if (this.suggestBuilder == null) {
            this.suggestBuilder = new SuggestBuilder("suggest");
        }
        return this.suggestBuilder;
    }

    public SearchSourceBuilder addRescorer(RescoreBuilder rescoreBuilder) {
        if (this.rescoreBuilders == null) {
            this.rescoreBuilders = new ArrayList<RescoreBuilder>();
        }
        this.rescoreBuilders.add(rescoreBuilder);
        return this;
    }

    public SearchSourceBuilder clearRescorers() {
        this.rescoreBuilders = null;
        return this;
    }

    public SearchSourceBuilder profile(boolean profile) {
        this.profile = profile;
        return this;
    }

    public boolean profile() {
        return this.profile;
    }

    public SearchSourceBuilder fetchSource(boolean fetch) {
        if (this.fetchSourceContext == null) {
            this.fetchSourceContext = new FetchSourceContext(fetch);
        } else {
            this.fetchSourceContext.fetchSource(fetch);
        }
        return this;
    }

    public SearchSourceBuilder fetchSource(@Nullable String include, @Nullable String exclude) {
        String[] stringArray;
        String[] stringArray2;
        if (include == null) {
            stringArray2 = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = include;
        }
        if (exclude == null) {
            stringArray = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = exclude;
        }
        return this.fetchSource(stringArray2, stringArray);
    }

    public SearchSourceBuilder fetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        this.fetchSourceContext = new FetchSourceContext(includes, excludes);
        return this;
    }

    public SearchSourceBuilder fetchSource(@Nullable FetchSourceContext fetchSourceContext) {
        this.fetchSourceContext = fetchSourceContext;
        return this;
    }

    public SearchSourceBuilder noFields() {
        this.fieldNames = Collections.emptyList();
        return this;
    }

    public SearchSourceBuilder fields(List<String> fields) {
        this.fieldNames = fields;
        return this;
    }

    public SearchSourceBuilder fields(String ... fields) {
        if (this.fieldNames == null) {
            this.fieldNames = new ArrayList<String>();
        }
        Collections.addAll(this.fieldNames, fields);
        return this;
    }

    public SearchSourceBuilder field(String name) {
        if (this.fieldNames == null) {
            this.fieldNames = new ArrayList<String>();
        }
        this.fieldNames.add(name);
        return this;
    }

    public SearchSourceBuilder fieldDataField(String name) {
        if (this.fieldDataFields == null) {
            this.fieldDataFields = new ArrayList<String>();
        }
        this.fieldDataFields.add(name);
        return this;
    }

    public SearchSourceBuilder scriptField(String name, Script script) {
        if (this.scriptFields == null) {
            this.scriptFields = new ArrayList<ScriptField>();
        }
        this.scriptFields.add(new ScriptField(name, script));
        return this;
    }

    public SearchSourceBuilder indexBoost(String index, float indexBoost) {
        if (this.indexBoost == null) {
            this.indexBoost = new ObjectFloatHashMap();
        }
        this.indexBoost.put((Object)index, indexBoost);
        return this;
    }

    public SearchSourceBuilder stats(String ... statsGroups) {
        this.stats = statsGroups;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.from != -1) {
            builder.field("from", this.from);
        }
        if (this.size != -1) {
            builder.field("size", this.size);
        }
        if (this.timeoutInMillis != -1L) {
            builder.field("timeout", this.timeoutInMillis);
        }
        if (this.terminateAfter != 0) {
            builder.field("terminate_after", this.terminateAfter);
        }
        if (this.querySourceBuilder != null) {
            this.querySourceBuilder.innerToXContent(builder, params);
        }
        if (this.postQueryBuilder != null) {
            builder.field("post_filter");
            this.postQueryBuilder.toXContent(builder, params);
        }
        if (this.filterBinary != null) {
            if (XContentFactory.xContentType(this.filterBinary) == builder.contentType()) {
                builder.rawField("filter", this.filterBinary);
            } else {
                builder.field("filter_binary", this.filterBinary);
            }
        }
        if (this.minScore != null) {
            builder.field("min_score", this.minScore);
        }
        if (this.version != null) {
            builder.field("version", (Object)this.version);
        }
        if (this.explain != null) {
            builder.field("explain", (Object)this.explain);
        }
        if (this.profile) {
            builder.field("profile", true);
        }
        if (this.fetchSourceContext != null) {
            if (!this.fetchSourceContext.fetchSource()) {
                builder.field("_source", false);
            } else {
                builder.startObject("_source");
                builder.array("includes", this.fetchSourceContext.includes());
                builder.array("excludes", this.fetchSourceContext.excludes());
                builder.endObject();
            }
        }
        if (this.fieldNames != null) {
            if (this.fieldNames.size() == 1) {
                builder.field("fields", this.fieldNames.get(0));
            } else {
                builder.startArray("fields");
                for (String fieldName : this.fieldNames) {
                    builder.value(fieldName);
                }
                builder.endArray();
            }
        }
        if (this.fieldDataFields != null) {
            builder.startArray("fielddata_fields");
            for (String fieldName : this.fieldDataFields) {
                builder.value(fieldName);
            }
            builder.endArray();
        }
        if (this.scriptFields != null) {
            builder.startObject("script_fields");
            for (ScriptField scriptField : this.scriptFields) {
                builder.startObject(scriptField.fieldName());
                builder.field("script", scriptField.script());
                builder.endObject();
            }
            builder.endObject();
        }
        if (this.sorts != null) {
            builder.startArray("sort");
            for (SortBuilder sort : this.sorts) {
                builder.startObject();
                sort.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.trackScores) {
            builder.field("track_scores", true);
        }
        if (this.indexBoost != null) {
            builder.startObject("indices_boost");
            assert (!this.indexBoost.containsKey(null));
            Object[] keys = this.indexBoost.keys;
            float[] values = this.indexBoost.values;
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i] == null) continue;
                builder.field((String)keys[i], values[i]);
            }
            builder.endObject();
        }
        if (this.aggregations != null) {
            builder.field("aggregations");
            builder.startObject();
            for (AbstractAggregationBuilder aggregation : this.aggregations) {
                aggregation.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (this.aggregationsBinary != null) {
            if (XContentFactory.xContentType(this.aggregationsBinary) == builder.contentType()) {
                builder.rawField("aggregations", this.aggregationsBinary);
            } else {
                builder.field("aggregations_binary", this.aggregationsBinary);
            }
        }
        if (this.highlightBuilder != null) {
            this.highlightBuilder.toXContent(builder, params);
        }
        if (this.innerHitsBuilder != null) {
            this.innerHitsBuilder.toXContent(builder, params);
        }
        if (this.suggestBuilder != null) {
            this.suggestBuilder.toXContent(builder, params);
        }
        if (this.rescoreBuilders != null) {
            Iterator<RescoreBuilder> itr = this.rescoreBuilders.iterator();
            while (itr.hasNext()) {
                if (!itr.next().isEmpty()) continue;
                itr.remove();
            }
            if (this.rescoreBuilders.size() == 1) {
                builder.startObject("rescore");
                this.rescoreBuilders.get(0).toXContent(builder, params);
                if (this.rescoreBuilders.get(0).windowSize() == null && this.defaultRescoreWindowSize != null) {
                    builder.field("window_size", this.defaultRescoreWindowSize);
                }
                builder.endObject();
            } else if (!this.rescoreBuilders.isEmpty()) {
                builder.startArray("rescore");
                for (RescoreBuilder rescoreBuilder : this.rescoreBuilders) {
                    builder.startObject();
                    rescoreBuilder.toXContent(builder, params);
                    if (rescoreBuilder.windowSize() == null && this.defaultRescoreWindowSize != null) {
                        builder.field("window_size", this.defaultRescoreWindowSize);
                    }
                    builder.endObject();
                }
                builder.endArray();
            }
        }
        if (this.stats != null) {
            builder.startArray("stats");
            for (Iterator<Object> iterator : this.stats) {
                builder.value((String)((Object)iterator));
            }
            builder.endArray();
        }
    }

    private static class ScriptField {
        private final String fieldName;
        private final Script script;

        private ScriptField(String fieldName, Script script) {
            this.fieldName = fieldName;
            this.script = script;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public Script script() {
            return this.script;
        }
    }
}

