/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.util.MinimalMap;
import org.elasticsearch.search.lookup.IndexField;

public class LeafIndexLookup
extends MinimalMap<String, IndexField> {
    private final LeafReader reader;
    private final IndexReader parentReader;
    private final IndexSearcher indexSearcher;
    private int docId = -1;
    private final Map<String, IndexField> indexFields = new HashMap<String, IndexField>();
    private int numDocs = -1;
    private int maxDoc = -1;
    private int numDeletedDocs = -1;

    public int numDocs() {
        if (this.numDocs == -1) {
            this.numDocs = this.parentReader.numDocs();
        }
        return this.numDocs;
    }

    public int maxDoc() {
        if (this.maxDoc == -1) {
            this.maxDoc = this.parentReader.maxDoc();
        }
        return this.maxDoc;
    }

    public int numDeletedDocs() {
        if (this.numDeletedDocs == -1) {
            this.numDeletedDocs = this.parentReader.numDeletedDocs();
        }
        return this.numDeletedDocs;
    }

    public LeafIndexLookup(LeafReaderContext ctx) {
        this.reader = ctx.reader();
        this.parentReader = ReaderUtil.getTopLevelContext((IndexReaderContext)ctx).reader();
        this.indexSearcher = new IndexSearcher(this.parentReader);
        this.indexSearcher.setQueryCache(null);
    }

    public void setDocument(int docId) {
        if (this.docId == docId) {
            return;
        }
        if (this.docId > docId) {
            this.indexFields.clear();
        }
        this.docId = docId;
        this.setNextDocIdInFields();
    }

    protected void setNextDocIdInFields() {
        for (IndexField stat : this.indexFields.values()) {
            stat.setDocIdInTerms(this.docId);
        }
    }

    @Override
    public IndexField get(Object key) {
        String stringField = (String)key;
        IndexField indexField = this.indexFields.get(key);
        if (indexField == null) {
            try {
                indexField = new IndexField(stringField, this);
                this.indexFields.put(stringField, indexField);
            }
            catch (IOException e) {
                throw new ElasticsearchException(e.getMessage(), new Object[0]);
            }
        }
        return indexField;
    }

    public Fields termVectors() throws IOException {
        assert (this.reader != null);
        return this.reader.getTermVectors(this.docId);
    }

    LeafReader getReader() {
        return this.reader;
    }

    public int getDocId() {
        return this.docId;
    }

    public IndexReader getParentReader() {
        if (this.parentReader == null) {
            return this.reader;
        }
        return this.parentReader;
    }

    public IndexSearcher getIndexSearcher() {
        return this.indexSearcher;
    }

    public IndexReaderContext getReaderContext() {
        return this.getParentReader().getContext();
    }
}

