/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.lucene.search.Query;
import org.elasticsearch.search.profile.ProfileBreakdown;
import org.elasticsearch.search.profile.ProfileResult;

final class InternalProfileTree {
    private ArrayList<ProfileBreakdown> timings = new ArrayList(10);
    private ArrayList<ArrayList<Integer>> tree;
    private ArrayList<Query> queries;
    private ArrayList<Integer> roots;
    private long rewriteTime;
    private long rewriteScratch;
    private Deque<Integer> stack = new LinkedBlockingDeque<Integer>(10);
    private int currentToken = 0;

    public InternalProfileTree() {
        this.tree = new ArrayList(10);
        this.queries = new ArrayList(10);
        this.roots = new ArrayList(10);
    }

    public ProfileBreakdown getQueryBreakdown(Query query) {
        int token = this.currentToken++;
        boolean stackEmpty = this.stack.isEmpty();
        if (stackEmpty) {
            this.roots.add(token);
            this.stack.add(token);
            return this.addDependencyNode(query, token);
        }
        this.updateParent(token);
        ++this.currentToken;
        this.stack.add(token);
        return this.addDependencyNode(query, token);
    }

    public void startRewriteTime() {
        assert (this.rewriteScratch == 0L);
        this.rewriteScratch = System.nanoTime();
    }

    public long stopAndAddRewriteTime() {
        long time = Math.max(1L, System.nanoTime() - this.rewriteScratch);
        this.rewriteTime += time;
        this.rewriteScratch = 0L;
        return time;
    }

    private ProfileBreakdown addDependencyNode(Query query, int token) {
        this.tree.add(new ArrayList(5));
        this.queries.add(query);
        ProfileBreakdown queryTimings = new ProfileBreakdown();
        this.timings.add(token, queryTimings);
        return queryTimings;
    }

    public void pollLast() {
        this.stack.pollLast();
    }

    public List<ProfileResult> getQueryTree() {
        ArrayList<ProfileResult> results = new ArrayList<ProfileResult>(5);
        for (Integer root : this.roots) {
            results.add(this.doGetQueryTree(root));
        }
        return results;
    }

    private ProfileResult doGetQueryTree(int token) {
        Query query = this.queries.get(token);
        ProfileBreakdown breakdown = this.timings.get(token);
        Map<String, Long> timings = breakdown.toTimingMap();
        List children = this.tree.get(token);
        List<ProfileResult> childrenProfileResults = Collections.emptyList();
        if (children != null) {
            childrenProfileResults = new ArrayList<ProfileResult>(children.size());
            for (Integer child : children) {
                ProfileResult childNode = this.doGetQueryTree(child);
                childrenProfileResults.add(childNode);
            }
        }
        long nodeTime = InternalProfileTree.getNodeTime(timings, childrenProfileResults);
        String queryDescription = query.getClass().getSimpleName();
        String luceneName = query.toString();
        return new ProfileResult(queryDescription, luceneName, timings, childrenProfileResults, nodeTime);
    }

    public long getRewriteTime() {
        return this.rewriteTime;
    }

    private void updateParent(int childToken) {
        Integer parent = this.stack.peekLast();
        ArrayList<Integer> parentNode = this.tree.get(parent);
        parentNode.add(childToken);
        this.tree.set(parent, parentNode);
    }

    private static long getNodeTime(Map<String, Long> timings, List<ProfileResult> children) {
        long nodeTime = 0L;
        Iterator<Object> iterator = timings.values().iterator();
        while (iterator.hasNext()) {
            long time = iterator.next();
            nodeTime += time;
        }
        for (ProfileResult child : children) {
            nodeTime += InternalProfileTree.getNodeTime(child.getTimeBreakdown(), child.getProfiledChildren());
        }
        return nodeTime;
    }
}

