/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.spatial4j.core.io.ShapeReader;
import com.spatial4j.core.io.ShapeWriter;
import com.spatial4j.core.shape.Shape;
import java.util.List;

public class SupportedFormats {
    private final List<ShapeReader> readers;
    private final List<ShapeWriter> writers;
    private final ShapeReader wktReader;
    private final ShapeWriter wktWriter;
    private final ShapeReader geoJsonReader;
    private final ShapeWriter geoJsonWriter;

    public SupportedFormats(List<ShapeReader> readers, List<ShapeWriter> writers) {
        this.readers = readers;
        this.writers = writers;
        this.wktReader = this.getReader("WKT");
        this.wktWriter = this.getWriter("WKT");
        this.geoJsonReader = this.getReader("GeoJSON");
        this.geoJsonWriter = this.getWriter("GeoJSON");
    }

    public List<ShapeReader> getReaders() {
        return this.readers;
    }

    public List<ShapeWriter> getWriters() {
        return this.writers;
    }

    public ShapeReader getReader(String fmt) {
        for (ShapeReader f : this.readers) {
            if (!fmt.equals(f.getFormatName())) continue;
            return f;
        }
        return null;
    }

    public ShapeWriter getWriter(String fmt) {
        for (ShapeWriter f : this.writers) {
            if (!fmt.equals(f.getFormatName())) continue;
            return f;
        }
        return null;
    }

    public ShapeReader getWktReader() {
        return this.wktReader;
    }

    public ShapeWriter getWktWriter() {
        return this.wktWriter;
    }

    public ShapeReader getGeoJsonReader() {
        return this.geoJsonReader;
    }

    public ShapeWriter getGeoJsonWriter() {
        return this.geoJsonWriter;
    }

    public Shape read(String value) {
        for (ShapeReader format : this.readers) {
            Shape v = format.readIfSupported(value);
            if (v == null) continue;
            return v;
        }
        return null;
    }
}

