/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.script.expression.DateMethodFunctionValues;
import org.elasticsearch.script.expression.FieldDataValueSource;
import org.elasticsearch.search.MultiValueMode;

class DateMethodValueSource
extends FieldDataValueSource {
    protected final String methodName;
    protected final int calendarType;

    DateMethodValueSource(IndexFieldData<?> indexFieldData, MultiValueMode multiValueMode, String methodName, int calendarType) {
        super(indexFieldData, multiValueMode);
        Objects.requireNonNull(methodName);
        this.methodName = methodName;
        this.calendarType = calendarType;
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext leaf) throws IOException {
        AtomicFieldData leafData = this.fieldData.load(leaf);
        assert (leafData instanceof AtomicNumericFieldData);
        return new DateMethodFunctionValues(this, this.multiValueMode, (AtomicNumericFieldData)leafData, this.calendarType);
    }

    @Override
    public String description() {
        return this.methodName + ": field(" + this.fieldData.getFieldNames().toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DateMethodValueSource that = (DateMethodValueSource)((Object)o);
        if (this.calendarType != that.calendarType) {
            return false;
        }
        return this.methodName.equals(that.methodName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.calendarType;
        return result;
    }
}

