/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.receivers.db.ConnectionSource;
import org.apache.log4j.receivers.db.DBHelper;
import org.apache.log4j.receivers.db.dialect.SQLDialect;
import org.apache.log4j.receivers.db.dialect.Util;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.log4j.xml.UnrecognizedElementHandler;
import org.w3c.dom.Element;

public class DBAppender
extends AppenderSkeleton
implements UnrecognizedElementHandler {
    static final String insertPropertiesSQL = "INSERT INTO  logging_event_property (event_id, mapped_key, mapped_value) VALUES (?, ?, ?)";
    static final String insertExceptionSQL = "INSERT INTO  logging_event_exception (event_id, i, trace_line) VALUES (?, ?, ?)";
    static final String insertSQL;
    private static final Method GET_GENERATED_KEYS_METHOD;
    ConnectionSource connectionSource;
    boolean cnxSupportsGetGeneratedKeys = false;
    boolean cnxSupportsBatchUpdates = false;
    SQLDialect sqlDialect;
    boolean locationInfo = false;

    public DBAppender() {
        super(false);
    }

    public void activateOptions() {
        LogLog.debug((String)"DBAppender.activateOptions called");
        if (this.connectionSource == null) {
            throw new IllegalStateException("DBAppender cannot function without a connection source");
        }
        this.sqlDialect = Util.getDialectFromCode(this.connectionSource.getSQLDialectCode());
        this.cnxSupportsGetGeneratedKeys = GET_GENERATED_KEYS_METHOD != null ? this.connectionSource.supportsGetGeneratedKeys() : false;
        this.cnxSupportsBatchUpdates = this.connectionSource.supportsBatchUpdates();
        if (!this.cnxSupportsGetGeneratedKeys && this.sqlDialect == null) {
            throw new IllegalStateException("DBAppender cannot function if the JDBC driver does not support getGeneratedKeys method *and* without a specific SQL dialect");
        }
        super.activateOptions();
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public void setConnectionSource(ConnectionSource connectionSource) {
        LogLog.debug((String)"setConnectionSource called for DBAppender");
        this.connectionSource = connectionSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(LoggingEvent event) {
        Connection connection = null;
        try {
            String[] strRep;
            Set propertiesKeys;
            connection = this.connectionSource.getConnection();
            connection.setAutoCommit(false);
            PreparedStatement insertStatement = this.cnxSupportsGetGeneratedKeys ? connection.prepareStatement(insertSQL, 1) : connection.prepareStatement(insertSQL);
            insertStatement.setLong(1, 0L);
            insertStatement.setLong(2, event.getTimeStamp());
            insertStatement.setString(3, event.getRenderedMessage());
            insertStatement.setString(4, event.getLoggerName());
            insertStatement.setString(5, event.getLevel().toString());
            insertStatement.setString(6, event.getNDC());
            insertStatement.setString(7, event.getThreadName());
            insertStatement.setShort(8, DBHelper.computeReferenceMask(event));
            LocationInfo li = event.locationInformationExists() || this.locationInfo ? event.getLocationInformation() : LocationInfo.NA_LOCATION_INFO;
            insertStatement.setString(9, li.getFileName());
            insertStatement.setString(10, li.getClassName());
            insertStatement.setString(11, li.getMethodName());
            insertStatement.setString(12, li.getLineNumber());
            int updateCount = insertStatement.executeUpdate();
            if (updateCount != 1) {
                LogLog.warn((String)"Failed to insert loggingEvent");
            }
            ResultSet rs = null;
            Statement idStatement = null;
            boolean gotGeneratedKeys = false;
            if (this.cnxSupportsGetGeneratedKeys) {
                try {
                    rs = (ResultSet)GET_GENERATED_KEYS_METHOD.invoke((Object)insertStatement, null);
                    gotGeneratedKeys = true;
                }
                catch (InvocationTargetException ex) {
                    Throwable target = ex.getTargetException();
                    if (target instanceof SQLException) {
                        throw (SQLException)target;
                    }
                    throw ex;
                }
                catch (IllegalAccessException ex) {
                    LogLog.warn((String)"IllegalAccessException invoking PreparedStatement.getGeneratedKeys", (Throwable)ex);
                }
            }
            if (!gotGeneratedKeys) {
                insertStatement.close();
                insertStatement = null;
                idStatement = connection.createStatement();
                idStatement.setMaxRows(1);
                rs = idStatement.executeQuery(this.sqlDialect.getSelectInsertId());
            }
            rs.next();
            int eventId = rs.getInt(1);
            rs.close();
            if (insertStatement != null) {
                insertStatement.close();
                insertStatement = null;
            }
            if (idStatement != null) {
                idStatement.close();
                idStatement = null;
            }
            if ((propertiesKeys = event.getPropertyKeySet()).size() > 0) {
                PreparedStatement insertPropertiesStatement = connection.prepareStatement(insertPropertiesSQL);
                Iterator i = propertiesKeys.iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    String value = event.getProperty(key);
                    insertPropertiesStatement.setInt(1, eventId);
                    insertPropertiesStatement.setString(2, key);
                    insertPropertiesStatement.setString(3, value);
                    if (this.cnxSupportsBatchUpdates) {
                        insertPropertiesStatement.addBatch();
                        continue;
                    }
                    insertPropertiesStatement.execute();
                }
                if (this.cnxSupportsBatchUpdates) {
                    insertPropertiesStatement.executeBatch();
                }
                insertPropertiesStatement.close();
                insertPropertiesStatement = null;
            }
            if ((strRep = event.getThrowableStrRep()) != null) {
                LogLog.debug((String)"Logging an exception");
                PreparedStatement insertExceptionStatement = connection.prepareStatement(insertExceptionSQL);
                for (short i = 0; i < strRep.length; i = (short)(i + 1)) {
                    insertExceptionStatement.setInt(1, eventId);
                    insertExceptionStatement.setShort(2, i);
                    insertExceptionStatement.setString(3, strRep[i]);
                    if (this.cnxSupportsBatchUpdates) {
                        insertExceptionStatement.addBatch();
                        continue;
                    }
                    insertExceptionStatement.execute();
                }
                if (this.cnxSupportsBatchUpdates) {
                    insertExceptionStatement.executeBatch();
                }
                insertExceptionStatement.close();
                insertExceptionStatement = null;
            }
            connection.commit();
        }
        catch (Throwable sqle) {
            LogLog.error((String)"problem appending event", (Throwable)sqle);
        }
        finally {
            DBHelper.closeConnection(connection);
        }
    }

    public void close() {
        this.closed = true;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public boolean requiresLayout() {
        return false;
    }

    public boolean parseUnrecognizedElement(Element element, Properties props) throws Exception {
        if ("connectionSource".equals(element.getNodeName())) {
            Object instance = DOMConfigurator.parseElement(element, props, ConnectionSource.class);
            if (instance instanceof ConnectionSource) {
                ConnectionSource source = (ConnectionSource)instance;
                source.activateOptions();
                this.setConnectionSource(source);
            }
            return true;
        }
        return false;
    }

    static {
        Method getGeneratedKeysMethod;
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO logging_event (");
        sql.append("sequence_number, ");
        sql.append("timestamp, ");
        sql.append("rendered_message, ");
        sql.append("logger_name, ");
        sql.append("level_string, ");
        sql.append("ndc, ");
        sql.append("thread_name, ");
        sql.append("reference_flag, ");
        sql.append("caller_filename, ");
        sql.append("caller_class, ");
        sql.append("caller_method, ");
        sql.append("caller_line) ");
        sql.append(" VALUES (?, ?, ? ,?, ?, ?, ?, ?, ?, ?, ?, ?)");
        insertSQL = sql.toString();
        try {
            getGeneratedKeysMethod = PreparedStatement.class.getMethod("getGeneratedKeys", null);
        }
        catch (Exception ex) {
            getGeneratedKeysMethod = null;
        }
        GET_GENERATED_KEYS_METHOD = getGeneratedKeysMethod;
    }
}

