/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.extras.DOMConfigurator;
import org.apache.log4j.rolling.TriggeringPolicy;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;
import org.apache.log4j.xml.UnrecognizedElementHandler;
import org.w3c.dom.Element;

public final class CompositeTriggeringPolicy
implements TriggeringPolicy,
UnrecognizedElementHandler {
    Set triggeringPolicies = new HashSet();

    public boolean isTriggeringEvent(Appender appender, LoggingEvent event, String file, long fileLength) {
        boolean isTriggered = false;
        Iterator iter = this.triggeringPolicies.iterator();
        while (iter.hasNext()) {
            boolean result = ((TriggeringPolicy)iter.next()).isTriggeringEvent(appender, event, file, fileLength);
            isTriggered = isTriggered || result;
        }
        return isTriggered;
    }

    public void addTriggeringPolicy(TriggeringPolicy policy) {
        this.triggeringPolicies.add(policy);
    }

    public void activateOptions() {
        Iterator iter = this.triggeringPolicies.iterator();
        while (iter.hasNext()) {
            ((TriggeringPolicy)iter.next()).activateOptions();
        }
    }

    public boolean parseUnrecognizedElement(Element element, Properties props) throws Exception {
        String nodeName = element.getNodeName();
        if ("triggeringPolicy".equals(nodeName)) {
            OptionHandler policy = DOMConfigurator.parseElement(element, props, TriggeringPolicy.class);
            if (policy instanceof TriggeringPolicy) {
                policy.activateOptions();
                this.addTriggeringPolicy((TriggeringPolicy)policy);
            }
            return true;
        }
        return false;
    }
}

