/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.IOException;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.search.suggest.BufferedInputIterator;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

public class UnsortedInputIterator
extends BufferedInputIterator {
    private final int[] ords;
    private int currentOrd = -1;
    private final BytesRefBuilder spare = new BytesRefBuilder();
    private final BytesRefBuilder payloadSpare = new BytesRefBuilder();

    public UnsortedInputIterator(InputIterator source) throws IOException {
        super(source);
        int i;
        this.ords = new int[this.entries.size()];
        Random random = new Random();
        for (i = 0; i < this.ords.length; ++i) {
            this.ords[i] = i;
        }
        for (i = 0; i < this.ords.length; ++i) {
            int randomPosition = random.nextInt(this.ords.length);
            int temp = this.ords[i];
            this.ords[i] = this.ords[randomPosition];
            this.ords[randomPosition] = temp;
        }
    }

    @Override
    public long weight() {
        assert (this.currentOrd == this.ords[this.curPos]);
        return this.freqs[this.currentOrd];
    }

    @Override
    public BytesRef next() throws IOException {
        if (++this.curPos < this.entries.size()) {
            this.currentOrd = this.ords[this.curPos];
            return this.entries.get(this.spare, this.currentOrd);
        }
        return null;
    }

    @Override
    public BytesRef payload() {
        if (this.hasPayloads() && this.curPos < this.payloads.size()) {
            assert (this.currentOrd == this.ords[this.curPos]);
            return this.payloads.get(this.payloadSpare, this.currentOrd);
        }
        return null;
    }

    @Override
    public Set<BytesRef> contexts() {
        if (this.hasContexts() && this.curPos < this.contextSets.size()) {
            assert (this.currentOrd == this.ords[this.curPos]);
            return (Set)this.contextSets.get(this.currentOrd);
        }
        return null;
    }
}

