/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;

public abstract class AbstractBulkByScrollRequestBuilder<Request extends AbstractBulkByScrollRequest<Request>, Response extends ActionResponse, Self extends AbstractBulkByScrollRequestBuilder<Request, Response, Self>>
extends ActionRequestBuilder<Request, Response, Self> {
    private final SearchRequestBuilder source;

    protected AbstractBulkByScrollRequestBuilder(ElasticsearchClient client, Action<Request, Response, Self> action, SearchRequestBuilder source, Request request) {
        super(client, action, request);
        this.source = source;
    }

    protected abstract Self self();

    public SearchRequestBuilder source() {
        return this.source;
    }

    public Self source(String ... indices) {
        this.source.setIndices(indices);
        return this.self();
    }

    public Self filter(QueryBuilder filter) {
        this.source.setQuery(filter);
        return this.self();
    }

    public Self size(int size) {
        ((AbstractBulkByScrollRequest)this.request).setSize(size);
        return this.self();
    }

    public Self abortOnVersionConflict(boolean abortOnVersionConflict) {
        ((AbstractBulkByScrollRequest)this.request).setAbortOnVersionConflict(abortOnVersionConflict);
        return this.self();
    }

    public Self refresh(boolean refresh) {
        ((AbstractBulkByScrollRequest)this.request).setRefresh(refresh);
        return this.self();
    }

    public Self timeout(TimeValue timeout) {
        ((AbstractBulkByScrollRequest)this.request).setTimeout(timeout);
        return this.self();
    }

    public Self consistency(WriteConsistencyLevel consistency) {
        ((AbstractBulkByScrollRequest)this.request).setConsistency(consistency);
        return this.self();
    }

    public Request request() {
        return (Request)((Object)this.beforeExecute((Request)((Object)((AbstractBulkByScrollRequest)this.request))));
    }

    protected Request beforeExecute(Request request) {
        ((AbstractBulkByScrollRequest)((Object)request)).getSearchRequest().source(this.source.internalBuilder());
        return request;
    }
}

