/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.reindex.AbstractBulkIndexByScrollRequest;

public class ReindexRequest
extends AbstractBulkIndexByScrollRequest<ReindexRequest>
implements CompositeIndicesRequest {
    private IndexRequest destination;

    public ReindexRequest() {
    }

    public ReindexRequest(SearchRequest search, IndexRequest destination) {
        super(search);
        this.destination = destination;
    }

    @Override
    protected ReindexRequest self() {
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException e = super.validate();
        if (this.getSearchRequest().indices() == null || this.getSearchRequest().indices().length == 0) {
            e = ValidateActions.addValidationError((String)"use _all if you really want to copy from all existing indexes", (ActionRequestValidationException)e);
        }
        if (this.destination.index() == null) {
            e = ValidateActions.addValidationError((String)"index must be specified", (ActionRequestValidationException)e);
            return e;
        }
        if (!this.routingIsValid()) {
            e = ValidateActions.addValidationError((String)"routing must be unset, [keep], [discard] or [=<some new value>]", (ActionRequestValidationException)e);
        }
        if (this.destination.versionType() == VersionType.INTERNAL && this.destination.version() != -3L) {
            e = ValidateActions.addValidationError((String)("unsupported version for internal versioning [" + this.destination.version() + ']'), (ActionRequestValidationException)e);
        }
        if (this.destination.ttl() != null) {
            e = ValidateActions.addValidationError((String)"setting ttl on destination isn't supported. use scripts instead.", (ActionRequestValidationException)e);
        }
        if (this.destination.timestamp() != null) {
            e = ValidateActions.addValidationError((String)"setting timestamp on destination isn't supported. use scripts instead.", (ActionRequestValidationException)e);
        }
        return e;
    }

    private boolean routingIsValid() {
        if (this.destination.routing() == null || this.destination.routing().startsWith("=")) {
            return true;
        }
        switch (this.destination.routing()) {
            case "keep": 
            case "discard": {
                return true;
            }
        }
        return false;
    }

    public IndexRequest getDestination() {
        return this.destination;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.destination = new IndexRequest();
        this.destination.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.destination.writeTo(out);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("reindex from ");
        this.searchToString(b);
        b.append(" to [").append(this.destination.index()).append(']');
        if (this.destination.type() != null) {
            b.append('[').append(this.destination.type()).append(']');
        }
        return b.toString();
    }

    public List<? extends IndicesRequest> subRequests() {
        assert (this.getSearchRequest() != null);
        assert (this.getDestination() != null);
        return Collections.unmodifiableList(Arrays.asList(this.getSearchRequest(), this.getDestination()));
    }
}

