/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.reindex.AbstractBaseReindexRestHandler;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.ReindexResponse;
import org.elasticsearch.index.reindex.TransportReindexAction;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.Script;

public class RestReindexAction
extends AbstractBaseReindexRestHandler<ReindexRequest, ReindexResponse, TransportReindexAction> {
    @Inject
    public RestReindexAction(Settings settings, RestController controller, Client client, ClusterService clusterService, TransportReindexAction action) {
        super(settings, controller, client, clusterService, action);
        controller.registerHandler(RestRequest.Method.POST, "/_reindex", (RestHandler)this);
    }

    public void handleRequest(RestRequest request, RestChannel channel, Client client) throws IOException {
        if (!request.hasContent()) {
            this.badRequest(channel, "body required");
            return;
        }
        ReindexRequest internalRequest = new ReindexRequest(new SearchRequest(), new IndexRequest());
        try (XContentParser xcontent = XContentFactory.xContent((BytesReference)request.content()).createParser(request.content());){
            this.parseRequest(xcontent, internalRequest);
        }
        catch (ElasticsearchParseException e) {
            this.logger.warn("Bad request", (Throwable)e, new Object[0]);
            this.badRequest(channel, e.getDetailedMessage());
            return;
        }
        RestReindexAction.parseCommon(internalRequest, request);
        this.execute(request, internalRequest, channel);
    }

    private void parseRequest(XContentParser parser, ReindexRequest request) throws IOException {
        String currentFieldName = null;
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("Reindex's request body must be an object.", new Object[0]);
        }
        block18: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                switch (currentFieldName) {
                    case "source": {
                        this.parseSource(parser, request.getSearchRequest());
                        continue block18;
                    }
                    case "dest": {
                        this.parseDest(parser, request.getDestination());
                        continue block18;
                    }
                    case "script": {
                        request.setScript(Script.parse((XContentParser)parser, (ParseFieldMatcher)this.parseFieldMatcher));
                        continue block18;
                    }
                }
                throw new ElasticsearchParseException("Unknown object field [{}]", new Object[]{currentFieldName});
            }
            if (token == XContentParser.Token.START_ARRAY) {
                throw new ElasticsearchParseException("Unknown array field [{}]", new Object[]{currentFieldName});
            }
            if (token.isValue()) {
                switch (currentFieldName) {
                    case "size": {
                        request.setSize(parser.intValue());
                        continue block18;
                    }
                    case "conflicts": {
                        request.setConflicts(parser.text());
                        continue block18;
                    }
                }
                throw new ElasticsearchParseException("Unknown value field [{}]", new Object[]{currentFieldName});
            }
            throw new ElasticsearchParseException("Unexpected token type [{}]", new Object[]{token});
        }
    }

    private void parseSource(XContentParser parser, SearchRequest search) throws IOException {
        String[] types;
        Map source = parser.map();
        String[] indices = RestReindexAction.extractStringArray(source, "index");
        if (indices != null) {
            search.indices(indices);
        }
        if ((types = RestReindexAction.extractStringArray(source, "type")) != null) {
            search.types(types);
        }
        XContentBuilder builder = XContentFactory.contentBuilder((XContentType)parser.contentType());
        builder.map(source);
        search.extraSource(builder);
    }

    private void parseDest(XContentParser parser, IndexRequest index) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        block20: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("Unknown object field [{}]", new Object[]{currentFieldName});
            }
            if (token == XContentParser.Token.START_ARRAY) {
                throw new ElasticsearchParseException("Unknown array field [{}]", new Object[]{currentFieldName});
            }
            if (token.isValue()) {
                switch (currentFieldName) {
                    case "index": {
                        index.index(parser.text());
                        continue block20;
                    }
                    case "type": {
                        index.type(parser.text());
                        continue block20;
                    }
                    case "routing": {
                        index.routing(parser.text());
                        continue block20;
                    }
                    case "opType": 
                    case "op_type": {
                        index.opType(parser.text());
                        continue block20;
                    }
                    case "versionType": 
                    case "version_type": {
                        index.versionType(VersionType.fromString((String)parser.text()));
                        continue block20;
                    }
                    case "timestamp": {
                        index.timestamp(parser.text());
                        continue block20;
                    }
                    case "ttl": {
                        index.ttl(parser.text());
                        continue block20;
                    }
                }
                throw new ElasticsearchParseException("Unknown value field [{}]", new Object[]{currentFieldName});
            }
            throw new ElasticsearchParseException("Unexpected token type [{}]", new Object[]{token});
        }
    }

    private void badRequest(RestChannel channel, String message) {
        try {
            XContentBuilder builder = channel.newErrorBuilder();
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, builder.startObject().field("error", message).endObject()));
        }
        catch (IOException e) {
            this.logger.warn("Failed to send response", (Throwable)e, new Object[0]);
        }
    }

    public static void parseCommon(AbstractBulkByScrollRequest<?> internalRequest, RestRequest request) {
        internalRequest.setRefresh(request.paramAsBoolean("refresh", internalRequest.isRefresh()));
        internalRequest.setTimeout(request.paramAsTime("timeout", internalRequest.getTimeout()));
        String consistency = request.param("consistency");
        if (consistency != null) {
            internalRequest.setConsistency(WriteConsistencyLevel.fromString((String)consistency));
        }
    }

    private static String[] extractStringArray(Map<String, Object> source, String name) {
        Object value = source.remove(name);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.toArray(new String[list.size()]);
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        throw new IllegalArgumentException("Expected [" + name + "] to be a list of a string but was [" + value + ']');
    }
}

