/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.reindex.AbstractAsyncBulkIndexByScrollAction;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponse;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateByQueryAction
extends HandledTransportAction<UpdateByQueryRequest, BulkIndexByScrollResponse> {
    private final ClusterService clusterService;
    private final Client client;
    private final ScriptService scriptService;

    @Inject
    public TransportUpdateByQueryAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, Client client, TransportService transportService, ScriptService scriptService) {
        super(settings, "indices:data/write/update/byquery", threadPool, transportService, actionFilters, indexNameExpressionResolver, UpdateByQueryRequest.class);
        this.clusterService = clusterService;
        this.client = client;
        this.scriptService = scriptService;
    }

    protected void doExecute(Task task, UpdateByQueryRequest request, ActionListener<BulkIndexByScrollResponse> listener) {
        new AsyncIndexBySearchAction((BulkByScrollTask)task, this.logger, this.scriptService, this.client, this.threadPool, this.clusterService.state().nodes().smallestNonClientNodeVersion(), request, listener).start();
    }

    protected void doExecute(UpdateByQueryRequest request, ActionListener<BulkIndexByScrollResponse> listener) {
        throw new UnsupportedOperationException("task required");
    }

    static class AsyncIndexBySearchAction
    extends AbstractAsyncBulkIndexByScrollAction<UpdateByQueryRequest, BulkIndexByScrollResponse> {
        public AsyncIndexBySearchAction(BulkByScrollTask task, ESLogger logger, ScriptService scriptService, Client client, ThreadPool threadPool, Version smallestNonClientVersion, UpdateByQueryRequest request, ActionListener<BulkIndexByScrollResponse> listener) {
            super(task, logger, scriptService, client, threadPool, smallestNonClientVersion, request, request.getSearchRequest(), listener);
        }

        @Override
        protected IndexRequest buildIndexRequest(SearchHit doc) {
            IndexRequest index = new IndexRequest((ActionRequest)this.mainRequest);
            index.index(doc.index());
            index.type(doc.type());
            index.id(doc.id());
            index.source(doc.sourceRef());
            index.versionType(VersionType.INTERNAL);
            index.version(doc.version());
            return index;
        }

        @Override
        protected BulkIndexByScrollResponse buildResponse(TimeValue took, List<BulkItemResponse.Failure> indexingFailures, List<ShardSearchFailure> searchFailures, boolean timedOut) {
            return new BulkIndexByScrollResponse(took, this.task.getStatus(), indexingFailures, searchFailures, timedOut);
        }

        @Override
        protected void scriptChangedIndex(IndexRequest index, Object to) {
            throw new IllegalArgumentException("Modifying [_index] not allowed");
        }

        @Override
        protected void scriptChangedType(IndexRequest index, Object to) {
            throw new IllegalArgumentException("Modifying [_type] not allowed");
        }

        @Override
        protected void scriptChangedId(IndexRequest index, Object to) {
            throw new IllegalArgumentException("Modifying [_id] not allowed");
        }

        @Override
        protected void scriptChangedVersion(IndexRequest index, Object to) {
            throw new IllegalArgumentException("Modifying [_version] not allowed");
        }

        @Override
        protected void scriptChangedRouting(IndexRequest index, Object to) {
            throw new IllegalArgumentException("Modifying [_routing] not allowed");
        }

        @Override
        protected void scriptChangedParent(IndexRequest index, Object to) {
            throw new IllegalArgumentException("Modifying [_parent] not allowed");
        }

        @Override
        protected void scriptChangedTimestamp(IndexRequest index, Object to) {
            throw new IllegalArgumentException("Modifying [_timestamp] not allowed");
        }

        @Override
        protected void scriptChangedTTL(IndexRequest index, Object to) {
            throw new IllegalArgumentException("Modifying [_ttl] not allowed");
        }
    }
}

