/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode;

import freemind.main.FreeMindMain;
import freemind.main.HtmlTools;
import freemind.modes.MindMap;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapEdgeModel;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;

public class MindMapNodeModel
extends NodeAdapter {
    public MindMapNodeModel(FreeMindMain frame, MindMap map) {
        this(null, frame, map);
    }

    public MindMapNodeModel(Object userObject, FreeMindMain frame, MindMap map) {
        super(userObject, frame, map);
        this.children = new LinkedList();
        this.setEdge(new MindMapEdgeModel(this, this.getFrame()));
    }

    @Override
    public String getPlainTextContent() {
        return HtmlTools.htmlToPlain(this.toString());
    }

    public void saveTXT(Writer fileout, int depth) throws IOException {
        String plainTextContent = this.getPlainTextContent();
        for (int i = 0; i < depth; ++i) {
            fileout.write("    ");
        }
        if (plainTextContent.matches(" *")) {
            fileout.write("o");
        } else if (this.getLink() != null) {
            String link = this.getLink();
            if (!link.equals(plainTextContent)) {
                fileout.write(plainTextContent + " ");
            }
            fileout.write("<" + link + ">");
        } else {
            fileout.write(plainTextContent);
        }
        fileout.write("\n");
        this.saveChildrenText(fileout, depth);
    }

    private void saveChildrenText(Writer fileout, int depth) throws IOException {
        ListIterator e = this.sortedChildrenUnfolded();
        while (e.hasNext()) {
            MindMapNodeModel child = (MindMapNodeModel)e.next();
            if (child.isVisible()) {
                child.saveTXT(fileout, depth + 1);
                continue;
            }
            child.saveChildrenText(fileout, depth);
        }
    }

    public void collectColors(HashSet colors) {
        if (this.color != null) {
            colors.add(this.getColor());
        }
        ListIterator e = this.childrenUnfolded();
        while (e.hasNext()) {
            ((MindMapNodeModel)e.next()).collectColors(colors);
        }
    }

    private String saveRFT_escapeUnicodeAndSpecialCharacters(String text) {
        int len = text.length();
        StringBuffer result = new StringBuffer(len);
        block6: for (int i = 0; i < len; ++i) {
            char myChar = text.charAt(i);
            char intValue = text.charAt(i);
            if (intValue > '\u0080') {
                result.append("\\u").append((int)intValue).append("?");
                continue;
            }
            switch (myChar) {
                case '\\': {
                    result.append("\\\\");
                    continue block6;
                }
                case '{': {
                    result.append("\\{");
                    continue block6;
                }
                case '}': {
                    result.append("\\}");
                    continue block6;
                }
                case '\n': {
                    result.append(" \\line ");
                    continue block6;
                }
                default: {
                    result.append(myChar);
                }
            }
        }
        return result.toString();
    }

    public void saveRTF(Writer fileout, int depth, HashMap colorTable) throws IOException {
        String pre = "{\\li" + depth * 350;
        String level = depth <= 8 ? "\\outlinelevel" + depth : "";
        String fontsize = "";
        if (this.color != null) {
            pre = pre + "\\cf" + (Integer)colorTable.get(this.getColor());
        }
        if (this.isItalic()) {
            pre = pre + "\\i ";
        }
        if (this.isBold()) {
            pre = pre + "\\b ";
        }
        if (this.font != null && this.font.getSize() != 0) {
            fontsize = "\\fs" + Math.round(1.5 * (double)this.getFont().getSize());
            pre = pre + fontsize;
        }
        pre = pre + "{}";
        fileout.write("\\li" + depth * 350 + level + "{}");
        if (this.toString().matches(" *")) {
            fileout.write("o");
        } else {
            String text = this.saveRFT_escapeUnicodeAndSpecialCharacters(this.getPlainTextContent());
            if (this.getLink() != null) {
                String link = this.saveRFT_escapeUnicodeAndSpecialCharacters(this.getLink());
                if (link.equals(this.toString())) {
                    fileout.write(pre + "<{\\ul\\cf1 " + link + "}>" + "}");
                } else {
                    fileout.write("{" + fontsize + pre + text + "} ");
                    fileout.write("<{\\ul\\cf1 " + link + "}}>");
                }
            } else {
                fileout.write(pre + text + "}");
            }
        }
        fileout.write("\\par");
        fileout.write("\n");
        this.saveChildrenRTF(fileout, depth, colorTable);
    }

    private void saveChildrenRTF(Writer fileout, int depth, HashMap colorTable) throws IOException {
        ListIterator e = this.sortedChildrenUnfolded();
        while (e.hasNext()) {
            MindMapNodeModel child = (MindMapNodeModel)e.next();
            if (child.isVisible()) {
                child.saveRTF(fileout, depth + 1, colorTable);
                continue;
            }
            child.saveChildrenRTF(fileout, depth, colorTable);
        }
    }

    @Override
    public boolean isWriteable() {
        return true;
    }
}

