/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.Transformer;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.DefaultVersionedComponentChooser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainArtifactResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainComponentMetaDataResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainDependencyToComponentIdResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleResolution;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleSource;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetaData;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;

public class UserResolverChain
implements ComponentResolvers {
    private final RepositoryChainDependencyToComponentIdResolver componentIdResolver;
    private final RepositoryChainComponentMetaDataResolver componentResolver;
    private final RepositoryChainArtifactResolver artifactResolver;
    private final ComponentSelectionRulesInternal componentSelectionRules;

    public UserResolverChain(VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator, ComponentSelectionRulesInternal componentSelectionRules) {
        this.componentSelectionRules = componentSelectionRules;
        DefaultVersionedComponentChooser componentChooser = new DefaultVersionedComponentChooser(versionComparator, versionSelectorScheme, componentSelectionRules);
        ModuleTransformer metaDataFactory = new ModuleTransformer();
        this.componentIdResolver = new RepositoryChainDependencyToComponentIdResolver(versionSelectorScheme, componentChooser, metaDataFactory);
        this.componentResolver = new RepositoryChainComponentMetaDataResolver(componentChooser, metaDataFactory);
        this.artifactResolver = new RepositoryChainArtifactResolver();
    }

    public DependencyToComponentIdResolver getComponentIdResolver() {
        return this.componentIdResolver;
    }

    public ComponentMetaDataResolver getComponentResolver() {
        return this.componentResolver;
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public ComponentSelectionRulesInternal getComponentSelectionRules() {
        return this.componentSelectionRules;
    }

    public void add(ModuleComponentRepository repository) {
        this.componentIdResolver.add(repository);
        this.componentResolver.add(repository);
        this.artifactResolver.add(repository);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModuleTransformer
    implements Transformer<ModuleComponentResolveMetaData, RepositoryChainModuleResolution> {
        private ModuleTransformer() {
        }

        public ModuleComponentResolveMetaData transform(RepositoryChainModuleResolution original) {
            RepositoryChainModuleSource moduleSource = new RepositoryChainModuleSource(original.repository.getId(), original.module.getSource());
            original.module.setSource(moduleSource);
            return original.module;
        }
    }
}

