/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.gradle.api.Transformer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractModuleExcludeRuleFilter;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ArtifactExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ExcludeAllModulesSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ExcludeNone;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.GroupNameExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.IvyPatternMatcherExcludeRuleSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExcludeRuleFilter;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleIdExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleNameExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.MultipleExcludeRulesFilter;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.UnionExcludeRuleFilter;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleExcludeRuleFilters {
    static final ExcludeNone EXCLUDE_NONE = new ExcludeNone();

    public static ModuleExcludeRuleFilter excludeNone() {
        return EXCLUDE_NONE;
    }

    public static ModuleExcludeRuleFilter excludeAny(ExcludeRule ... excludeRules) {
        if (excludeRules.length == 0) {
            return EXCLUDE_NONE;
        }
        return ModuleExcludeRuleFilters.excludeAny(Arrays.asList(excludeRules));
    }

    public static ModuleExcludeRuleFilter excludeAny(Collection<ExcludeRule> excludeRules) {
        if (excludeRules.isEmpty()) {
            return EXCLUDE_NONE;
        }
        return new MultipleExcludeRulesFilter(CollectionUtils.collect(excludeRules, (Transformer)new Transformer<AbstractModuleExcludeRuleFilter, ExcludeRule>(){

            public AbstractModuleExcludeRuleFilter transform(ExcludeRule excludeRule) {
                return ModuleExcludeRuleFilters.forIvyExcludeRule(excludeRule);
            }
        }));
    }

    private static AbstractModuleExcludeRuleFilter forIvyExcludeRule(ExcludeRule rule) {
        boolean anyArtifact;
        if (!(rule.getMatcher() instanceof ExactPatternMatcher)) {
            return new IvyPatternMatcherExcludeRuleSpec(rule);
        }
        ArtifactId artifactId = rule.getId();
        ModuleId moduleId = artifactId.getModuleId();
        boolean anyOrganisation = AbstractModuleExcludeRuleFilter.isWildcard(moduleId.getOrganisation());
        boolean anyModule = AbstractModuleExcludeRuleFilter.isWildcard(moduleId.getName());
        boolean bl = anyArtifact = AbstractModuleExcludeRuleFilter.isWildcard(artifactId.getName()) && AbstractModuleExcludeRuleFilter.isWildcard(artifactId.getType()) && AbstractModuleExcludeRuleFilter.isWildcard(artifactId.getExt());
        if (anyArtifact) {
            if (!anyOrganisation && !anyModule) {
                return new ModuleIdExcludeSpec(moduleId.getOrganisation(), moduleId.getName());
            }
            if (!anyModule) {
                return new ModuleNameExcludeSpec(moduleId.getName());
            }
            if (!anyOrganisation) {
                return new GroupNameExcludeSpec(moduleId.getOrganisation());
            }
            return new ExcludeAllModulesSpec();
        }
        return new ArtifactExcludeSpec(artifactId);
    }

    public static ModuleExcludeRuleFilter union(ModuleExcludeRuleFilter one, ModuleExcludeRuleFilter two) {
        if (one == two) {
            return one;
        }
        if (one == EXCLUDE_NONE || two == EXCLUDE_NONE) {
            return EXCLUDE_NONE;
        }
        ArrayList<AbstractModuleExcludeRuleFilter> specs = new ArrayList<AbstractModuleExcludeRuleFilter>();
        ((AbstractModuleExcludeRuleFilter)one).unpackUnion(specs);
        ((AbstractModuleExcludeRuleFilter)two).unpackUnion(specs);
        int i = 0;
        while (i < specs.size()) {
            AbstractModuleExcludeRuleFilter spec = (AbstractModuleExcludeRuleFilter)specs.get(i);
            AbstractModuleExcludeRuleFilter merged = null;
            for (int j = i + 1; j < specs.size(); ++j) {
                merged = spec.maybeMergeIntoUnion((AbstractModuleExcludeRuleFilter)specs.get(j));
                if (merged == null) continue;
                specs.remove(j);
                break;
            }
            if (merged != null) {
                specs.set(i, merged);
                continue;
            }
            ++i;
        }
        if (specs.size() == 1) {
            return (ModuleExcludeRuleFilter)specs.get(0);
        }
        return new UnionExcludeRuleFilter(specs);
    }

    public static ModuleExcludeRuleFilter intersect(ModuleExcludeRuleFilter one, ModuleExcludeRuleFilter two) {
        if (one == two) {
            return one;
        }
        if (one == EXCLUDE_NONE) {
            return two;
        }
        if (two == EXCLUDE_NONE) {
            return one;
        }
        ArrayList<AbstractModuleExcludeRuleFilter> specs = new ArrayList<AbstractModuleExcludeRuleFilter>();
        ((AbstractModuleExcludeRuleFilter)one).unpackIntersection(specs);
        ((AbstractModuleExcludeRuleFilter)two).unpackIntersection(specs);
        return new MultipleExcludeRulesFilter(specs);
    }
}

