/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import java.io.File;
import java.util.Map;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.artifacts.BaseRepositoryFactory;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.ResolverStrategy;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.internal.artifacts.repositories.DefaultFlatDirArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultIvyArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenLocalArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.authentication.AuthenticationSchemeRegistry;
import org.gradle.internal.authentication.DefaultAuthenticationContainer;
import org.gradle.internal.component.external.model.DefaultMavenModuleResolveMetaData;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetaData;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBaseRepositoryFactory
implements BaseRepositoryFactory {
    private final LocalMavenRepositoryLocator localMavenRepositoryLocator;
    private final FileResolver fileResolver;
    private final Instantiator instantiator;
    private final RepositoryTransportFactory transportFactory;
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetaData> locallyAvailableResourceFinder;
    private final ResolverStrategy resolverStrategy;
    private final FileStore<ModuleComponentArtifactMetaData> artifactFileStore;
    private final MetaDataParser<DefaultMavenModuleResolveMetaData> pomParser;
    private final AuthenticationSchemeRegistry authenticationSchemeRegistry;

    public DefaultBaseRepositoryFactory(LocalMavenRepositoryLocator localMavenRepositoryLocator, FileResolver fileResolver, Instantiator instantiator, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetaData> locallyAvailableResourceFinder, ResolverStrategy resolverStrategy, FileStore<ModuleComponentArtifactMetaData> artifactFileStore, MetaDataParser<DefaultMavenModuleResolveMetaData> pomParser, AuthenticationSchemeRegistry authenticationSchemeRegistry) {
        this.localMavenRepositoryLocator = localMavenRepositoryLocator;
        this.fileResolver = fileResolver;
        this.instantiator = instantiator;
        this.transportFactory = transportFactory;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.resolverStrategy = resolverStrategy;
        this.artifactFileStore = artifactFileStore;
        this.pomParser = pomParser;
        this.authenticationSchemeRegistry = authenticationSchemeRegistry;
    }

    public FlatDirectoryArtifactRepository createFlatDirRepository() {
        return (FlatDirectoryArtifactRepository)this.instantiator.newInstance(DefaultFlatDirArtifactRepository.class, new Object[]{this.fileResolver, this.transportFactory, this.locallyAvailableResourceFinder, this.resolverStrategy, this.artifactFileStore});
    }

    public MavenArtifactRepository createMavenLocalRepository() {
        MavenArtifactRepository mavenRepository = (MavenArtifactRepository)this.instantiator.newInstance(DefaultMavenLocalArtifactRepository.class, new Object[]{this.fileResolver, this.transportFactory, this.locallyAvailableResourceFinder, this.instantiator, this.artifactFileStore, this.pomParser, this.createAuthenticationContainer()});
        File localMavenRepository = this.localMavenRepositoryLocator.getLocalMavenRepository();
        mavenRepository.setUrl((Object)localMavenRepository);
        return mavenRepository;
    }

    public MavenArtifactRepository createJCenterRepository() {
        MavenArtifactRepository mavenRepository = this.createMavenRepository();
        mavenRepository.setUrl((Object)"https://jcenter.bintray.com/");
        return mavenRepository;
    }

    public MavenArtifactRepository createMavenCentralRepository() {
        MavenArtifactRepository mavenRepository = this.createMavenRepository();
        mavenRepository.setUrl((Object)"https://repo1.maven.org/maven2/");
        return mavenRepository;
    }

    public IvyArtifactRepository createIvyRepository() {
        return (IvyArtifactRepository)this.instantiator.newInstance(DefaultIvyArtifactRepository.class, new Object[]{this.fileResolver, this.transportFactory, this.locallyAvailableResourceFinder, this.instantiator, this.resolverStrategy, this.artifactFileStore, this.createAuthenticationContainer()});
    }

    public MavenArtifactRepository createMavenRepository() {
        return (MavenArtifactRepository)this.instantiator.newInstance(DefaultMavenArtifactRepository.class, new Object[]{this.fileResolver, this.transportFactory, this.locallyAvailableResourceFinder, this.instantiator, this.artifactFileStore, this.pomParser, this.createAuthenticationContainer()});
    }

    protected AuthenticationContainer createAuthenticationContainer() {
        DefaultAuthenticationContainer container = (DefaultAuthenticationContainer)this.instantiator.newInstance(DefaultAuthenticationContainer.class, new Object[]{this.instantiator});
        for (Map.Entry e : this.authenticationSchemeRegistry.getRegisteredSchemes().entrySet()) {
            container.registerBinding((Class)e.getKey(), (Class)e.getValue());
        }
        return container;
    }
}

