/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.result;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.component.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComponentArtifactsResult
implements ComponentArtifactsResult {
    private final ComponentIdentifier componentIdentifier;
    private final Set<ArtifactResult> artifactResults = Sets.newHashSet();

    public DefaultComponentArtifactsResult(ComponentIdentifier componentIdentifier) {
        this.componentIdentifier = componentIdentifier;
    }

    public ComponentIdentifier getId() {
        return this.componentIdentifier;
    }

    public Set<ArtifactResult> getArtifacts(Class<? extends Artifact> type) {
        LinkedHashSet matching = Sets.newLinkedHashSet();
        for (ArtifactResult artifactResult : this.artifactResults) {
            if (!type.isAssignableFrom(artifactResult.getType())) continue;
            matching.add(artifactResult);
        }
        return matching;
    }

    public void addArtifact(ArtifactResult artifact) {
        this.artifactResults.add(artifact);
    }
}

