/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results;

import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestOutputListener;
import org.gradle.api.tasks.testing.TestResult;

public class TestListenerAdapter
implements TestListenerInternal {
    private final TestListener testListener;
    private final TestOutputListener testOutputListener;

    public TestListenerAdapter(TestListener testListener, TestOutputListener testOutputListener) {
        this.testListener = testListener;
        this.testOutputListener = testOutputListener;
    }

    public void started(TestDescriptorInternal test, TestStartEvent startEvent) {
        if (test.isComposite()) {
            this.testListener.beforeSuite(test);
        } else {
            this.testListener.beforeTest(test);
        }
    }

    public void completed(TestDescriptorInternal test, TestResult result, TestCompleteEvent completeEvent) {
        if (test.isComposite()) {
            this.testListener.afterSuite(test, result);
        } else {
            this.testListener.afterTest(test, result);
        }
    }

    public void output(TestDescriptorInternal test, TestOutputEvent event) {
        this.testOutputListener.onOutput(test, event);
    }
}

