/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.EmbeddedServletOptions;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.apache.jasper.runtime.ResourceInjector;
import org.apache.jasper.servlet.JspServletWrapper;

public class JspServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog(JspServlet.class);
    private ServletContext context;
    private ServletConfig config;
    private Options options;
    private JspRuntimeContext rctxt;
    private int countErrors;
    private Object errorCountLk = new Object();
    private String httpMethodsString = null;
    private HashSet httpMethodsSet = null;
    private ConcurrentHashMap<String, TagLibraryInfo> taglibs;
    private ConcurrentHashMap<String, URL> tagFileJarUrls;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.context = config.getServletContext();
        this.options = new EmbeddedServletOptions(config, this.context);
        this.rctxt = new JspRuntimeContext(this.context, this.options);
        String resourceInjectorClassName = config.getInitParameter("com.sun.appserv.jsp.resource.injector");
        if (resourceInjectorClassName != null) {
            try {
                ResourceInjector ri = (ResourceInjector)Class.forName(resourceInjectorClassName).newInstance();
                ri.setContext(this.context);
                this.context.setAttribute("com.sun.appserv.jsp.resource.injector", (Object)ri);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        this.httpMethodsString = config.getInitParameter("httpMethods");
        if (this.httpMethodsString != null && !this.httpMethodsString.equals("*")) {
            this.httpMethodsSet = new HashSet();
            StringTokenizer tokenizer = new StringTokenizer(this.httpMethodsString, ", \t\n\r\f");
            while (tokenizer.hasMoreTokens()) {
                this.httpMethodsSet.add(tokenizer.nextToken());
            }
        }
        this.taglibs = new ConcurrentHashMap();
        this.context.setAttribute("com.sun.jsp.taglibraryCache", this.taglibs);
        this.tagFileJarUrls = new ConcurrentHashMap();
        this.context.setAttribute("com.sun.jsp.tagFileJarUrlsCache", this.tagFileJarUrls);
        if (log.isTraceEnabled()) {
            log.trace(Localizer.getMessage("jsp.message.scratch.dir.is", this.options.getScratchDir().toString()));
            log.trace(Localizer.getMessage("jsp.message.dont.modify.servlets"));
        }
    }

    public int getJspCount() {
        return this.rctxt.getJspCount();
    }

    public void setJspReloadCount(int count) {
        this.rctxt.setJspReloadCount(count);
    }

    public int getJspReloadCount() {
        return this.rctxt.getJspReloadCount();
    }

    public int getJspErrorCount() {
        return this.countErrors;
    }

    boolean preCompile(HttpServletRequest request) throws ServletException {
        String value;
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        int start = queryString.indexOf("jsp_precompile");
        if (start < 0) {
            return false;
        }
        if ((queryString = queryString.substring(start + "jsp_precompile".length())).length() == 0) {
            return true;
        }
        if (queryString.startsWith("&")) {
            return true;
        }
        if (!queryString.startsWith("=")) {
            return false;
        }
        int limit = queryString.length();
        int ampersand = queryString.indexOf("&");
        if (ampersand > 0) {
            limit = ampersand;
        }
        if ((value = queryString.substring(1, limit)).equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return true;
        }
        throw new ServletException("Cannot have request parameter jsp_precompile set to " + value);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.httpMethodsSet != null) {
            String method = request.getMethod();
            if (method == null) {
                return;
            }
            boolean isSupportedMethod = this.httpMethodsSet.contains(method);
            if (!isSupportedMethod) {
                if (method.equals("OPTIONS")) {
                    response.addHeader("Allow", this.httpMethodsString);
                } else {
                    super.service(request, response);
                }
                return;
            }
        }
        String jspUri = null;
        String jspFile = (String)request.getAttribute("org.apache.catalina.jsp_file");
        if (jspFile != null) {
            jspUri = jspFile;
            request.removeAttribute("org.apache.catalina.jsp_file");
        } else {
            String pathInfo;
            jspUri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            if (jspUri != null) {
                pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
                if (pathInfo != null) {
                    jspUri = jspUri + pathInfo;
                }
            } else {
                jspUri = request.getServletPath();
                pathInfo = request.getPathInfo();
                if (pathInfo != null) {
                    jspUri = jspUri + pathInfo;
                }
            }
        }
        if (log.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer();
            msg.append("JspEngine --> [" + jspUri);
            msg.append("] ServletPath: [" + request.getServletPath());
            msg.append("] PathInfo: [" + request.getPathInfo());
            msg.append("] RealPath: [" + this.context.getRealPath(jspUri));
            msg.append("] RequestURI: [" + request.getRequestURI());
            msg.append("] QueryString: [" + request.getQueryString());
            msg.append("]");
            log.debug(msg);
        }
        try {
            boolean precompile = this.preCompile(request);
            this.serviceJspFile(request, response, jspUri, null, precompile);
        }
        catch (RuntimeException e) {
            this.incrementErrorCount();
            throw e;
        }
        catch (ServletException e) {
            this.incrementErrorCount();
            throw e;
        }
        catch (IOException e) {
            this.incrementErrorCount();
            throw e;
        }
        catch (Throwable e) {
            this.incrementErrorCount();
            throw new ServletException(e);
        }
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug("JspServlet.destroy()");
        }
        this.rctxt.destroy();
        JspApplicationContextImpl.removeJspApplicationContext(this.context);
        this.taglibs.clear();
        this.tagFileJarUrls.clear();
        HashMap tldUriToLocationMap = (HashMap)this.context.getAttribute("com.sun.jsp.tldUriToLocationMap");
        if (tldUriToLocationMap != null) {
            tldUriToLocationMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceJspFile(HttpServletRequest request, HttpServletResponse response, String jspUri, Throwable exception, boolean precompile) throws ServletException, IOException {
        JspServletWrapper wrapper = this.rctxt.getWrapper(jspUri);
        if (wrapper == null) {
            JspServlet jspServlet = this;
            synchronized (jspServlet) {
                wrapper = this.rctxt.getWrapper(jspUri);
                if (wrapper == null) {
                    if (null == this.context.getResource(jspUri) && !this.options.getUsePrecompiled()) {
                        String includeRequestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
                        if (includeRequestUri != null) {
                            throw new FileNotFoundException(jspUri);
                        }
                        response.sendError(404);
                        log.error(Localizer.getMessage("jsp.error.file.not.found", this.context.getRealPath(jspUri)));
                        return;
                    }
                    boolean isErrorPage = exception != null;
                    wrapper = new JspServletWrapper(this.config, this.options, jspUri, isErrorPage, this.rctxt);
                    this.rctxt.addWrapper(jspUri, wrapper);
                }
            }
        }
        wrapper.service(request, response, precompile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementErrorCount() {
        Object object = this.errorCountLk;
        synchronized (object) {
            ++this.countErrors;
        }
    }
}

