/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.server.health.DaemonStats;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionStats;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectorMonitoringStrategy;

public class DaemonStatus {
    Logger logger = Logging.getLogger(DaemonStatus.class);
    public static final String ENABLE_PERFORMANCE_MONITORING = "org.gradle.daemon.performance.enable-monitoring";
    public static final String TENURED_USAGE_EXPIRE_AT = "org.gradle.daemon.performance.tenured-usage-expire-at";
    public static final String TENURED_RATE_EXPIRE_AT = "org.gradle.daemon.performance.tenured-rate-expire-at";
    private final DaemonStats stats;

    public DaemonStatus(DaemonStats stats) {
        this.stats = stats;
    }

    boolean isDaemonUnhealthy() {
        return this.isTenuredSpaceExhausted();
    }

    public boolean isTenuredSpaceExhausted() {
        if (!this.isEnabled()) {
            return false;
        }
        GarbageCollectorMonitoringStrategy strategy = this.stats.getGcMonitor().getGcStrategy();
        if (strategy != GarbageCollectorMonitoringStrategy.UNKNOWN) {
            int tenuredUsageThreshold = DaemonStatus.parseValue(TENURED_USAGE_EXPIRE_AT, strategy.getTenuredUsageThreshold());
            if (tenuredUsageThreshold == 0) {
                return false;
            }
            double tenuredRateThreshold = DaemonStatus.parseValue(TENURED_RATE_EXPIRE_AT, strategy.getGcRateThreshold());
            if (tenuredRateThreshold == 0.0) {
                return false;
            }
            GarbageCollectionStats gcStats = this.stats.getGcMonitor().getTenuredStats();
            if (gcStats.getUsage() > 0) {
                this.logger.debug(String.format("GC rate: %.2f/s tenured usage: %s%%", gcStats.getRate(), gcStats.getUsage()));
            } else {
                this.logger.debug("GC rate: 0.0/s");
            }
            if (gcStats.getEventCount() >= 5L && gcStats.getUsage() >= tenuredUsageThreshold && gcStats.getRate() >= tenuredRateThreshold) {
                return true;
            }
        }
        return false;
    }

    private boolean isEnabled() {
        String enabledValue = System.getProperty(ENABLE_PERFORMANCE_MONITORING, "true");
        return Boolean.parseBoolean(enabledValue);
    }

    private static int parseValue(String property, int defaultValue) {
        String expireAt = System.getProperty(property);
        if (expireAt == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(expireAt);
        }
        catch (Exception e) {
            throw new GradleException(String.format("System property '%s' has incorrect value: '%s'. The value needs to be an integer.", property, expireAt));
        }
    }

    private static double parseValue(String property, double defaultValue) {
        String expireAt = System.getProperty(property);
        if (expireAt == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(expireAt);
        }
        catch (Exception e) {
            throw new GradleException(String.format("System property '%s' has incorrect value: '%s'. The value needs to be a double.", property, expireAt));
        }
    }
}

