/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;

public class MemoryInfo {
    private final long totalMemory = Runtime.getRuntime().maxMemory();

    public long getCollectionTime() {
        long garbageCollectionTime = 0L;
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            long time = gc.getCollectionTime();
            if (time < 0L) continue;
            garbageCollectionTime += time;
        }
        return garbageCollectionTime;
    }

    public long getMaxMemory() {
        return this.totalMemory;
    }

    public long getCommittedMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public long getTotalPhysicalMemory() {
        return MemoryInfo.sunBean("getTotalPhysicalMemorySize");
    }

    public long getFreePhysicalMemory() {
        return MemoryInfo.sunBean("getFreePhysicalMemorySize");
    }

    private static long sunBean(String methodName) {
        OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        ReflectiveOperationException rootCause = null;
        ClassLoader beanLoader = ClassLoader.getSystemClassLoader();
        try {
            Class<?> osbean = beanLoader.loadClass("com.sun.management.OperatingSystemMXBean");
            return (Long)osbean.getMethod(methodName, new Class[0]).invoke((Object)bean, new Object[0]);
        }
        catch (IllegalAccessException e) {
            rootCause = e;
        }
        catch (InvocationTargetException e) {
            rootCause = e;
        }
        catch (NoSuchMethodException e) {
            rootCause = e;
        }
        catch (ClassNotFoundException e) {
            rootCause = e;
        }
        throw new UnsupportedOperationException(methodName + " is unsupported on this JVM.", rootCause);
    }
}

