/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ArtifactWithDependencies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectArtifact
extends DefaultArtifact
implements ArtifactWithDependencies {
    private MavenProject project;

    public ProjectArtifact(MavenProject project) {
        super(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, "pom", null, (ArtifactHandler)new PomArtifactHandler());
        this.project = project;
        this.setFile(project.getFile());
        this.setResolved(true);
    }

    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public List<Dependency> getDependencies() {
        return this.project.getDependencies();
    }

    @Override
    public List<Dependency> getManagedDependencies() {
        DependencyManagement depMngt = this.project.getDependencyManagement();
        return depMngt != null ? depMngt.getDependencies() : Collections.emptyList();
    }

    static class PomArtifactHandler
    implements ArtifactHandler {
        PomArtifactHandler() {
        }

        public String getClassifier() {
            return null;
        }

        public String getDirectory() {
            return null;
        }

        public String getExtension() {
            return "pom";
        }

        public String getLanguage() {
            return "none";
        }

        public String getPackaging() {
            return "pom";
        }

        public boolean isAddedToClasspath() {
            return false;
        }

        public boolean isIncludesDependencies() {
            return false;
        }
    }
}

