/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.osgi;

import groovy.lang.Closure;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.plugins.osgi.DefaultOsgiManifest;
import org.gradle.api.internal.plugins.osgi.OsgiHelper;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.osgi.OsgiManifest;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;

public class OsgiPluginConvention {
    private ProjectInternal project;

    public OsgiPluginConvention(ProjectInternal project) {
        this.project = project;
    }

    public OsgiManifest osgiManifest() {
        return this.osgiManifest(null);
    }

    public OsgiManifest osgiManifest(Closure closure) {
        return (OsgiManifest)ConfigureUtil.configure((Closure)closure, (Object)this.createDefaultOsgiManifest(this.project));
    }

    private OsgiManifest createDefaultOsgiManifest(final ProjectInternal project) {
        OsgiManifest osgiManifest = (OsgiManifest)((Instantiator)project.getServices().get(Instantiator.class)).newInstance(DefaultOsgiManifest.class, new Object[]{project.getFileResolver()});
        ConventionMapping mapping = ((IConventionAware)osgiManifest).getConventionMapping();
        final OsgiHelper osgiHelper = new OsgiHelper();
        mapping.map("version", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return osgiHelper.getVersion(project.getVersion().toString());
            }
        });
        mapping.map("name", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((BasePluginConvention)project.getConvention().getPlugin(BasePluginConvention.class)).getArchivesBaseName();
            }
        });
        mapping.map("symbolicName", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return osgiHelper.getBundleSymbolicName((Project)project);
            }
        });
        return osgiManifest;
    }
}

