/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.api;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.listener.ActionBroadcast;
import org.gradle.plugins.ide.internal.generator.generator.Generator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorTask<T>
extends ConventionTask {
    private File inputFile;
    private File outputFile;
    protected final ActionBroadcast<T> beforeConfigured = new ActionBroadcast();
    protected final ActionBroadcast<T> afterConfigured = new ActionBroadcast();
    protected Generator<T> generator;
    protected T domainObject;

    public GeneratorTask() {
        this.getOutputs().upToDateWhen(Specs.satisfyNone());
    }

    @TaskAction
    void generate() {
        File inputFile = this.getInputFile();
        if (inputFile != null && inputFile.exists()) {
            try {
                this.domainObject = this.generator.read(inputFile);
            }
            catch (RuntimeException e) {
                throw new GradleException(String.format("Cannot parse file '%s'.\n       Perhaps this file was tinkered with? In that case try delete this file and then retry.", inputFile), (Throwable)e);
            }
        } else {
            this.domainObject = this.generator.defaultInstance();
        }
        this.beforeConfigured.execute(this.domainObject);
        this.generator.configure(this.domainObject);
        this.afterConfigured.execute(this.domainObject);
        this.generator.write(this.domainObject, this.getOutputFile());
    }

    @Inject
    protected Instantiator getInstantiator() {
        throw new UnsupportedOperationException();
    }

    public File getInputFile() {
        return this.inputFile != null ? this.inputFile : this.getOutputFile();
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }
}

