/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Specs;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseWtpComponent;
import org.gradle.plugins.ide.eclipse.model.FileReference;
import org.gradle.plugins.ide.eclipse.model.WbDependentModule;
import org.gradle.plugins.ide.eclipse.model.WbResource;
import org.gradle.plugins.ide.eclipse.model.WtpComponent;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;
import org.gradle.plugins.ide.internal.IdeDependenciesExtractor;
import org.gradle.plugins.ide.internal.resolver.model.IdeExtendedRepoFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeLocalFileDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WtpComponentFactory {
    public void configure(EclipseWtpComponent wtp, WtpComponent component) {
        ArrayList entries = Lists.newArrayList();
        entries.addAll(this.getEntriesFromSourceDirs(wtp));
        for (WbResource element : wtp.getResources()) {
            if (!wtp.getProject().file((Object)element.getSourcePath()).isDirectory()) continue;
            entries.add(element);
        }
        entries.addAll(wtp.getProperties());
        entries.addAll(this.getEntriesFromConfigurations(this.configOrEmptySet(wtp.getRootConfigurations()), this.configOrEmptySet(wtp.getMinusConfigurations()), wtp, "/", false));
        entries.addAll(this.getEntriesFromConfigurations(this.configOrEmptySet(wtp.getLibConfigurations()), this.configOrEmptySet(wtp.getMinusConfigurations()), wtp, wtp.getLibDeployPath(), true));
        component.configure(wtp.getDeployName(), wtp.getContextPath(), entries);
    }

    private Set<Configuration> configOrEmptySet(Set<Configuration> configuration) {
        if (configuration == null) {
            return Sets.newHashSet();
        }
        return configuration;
    }

    private List<WbResource> getEntriesFromSourceDirs(EclipseWtpComponent wtp) {
        ArrayList result = Lists.newArrayList();
        if (wtp.getSourceDirs() != null) {
            for (File dir : wtp.getSourceDirs()) {
                if (!dir.isDirectory()) continue;
                result.add(new WbResource(wtp.getClassesDeployPath(), wtp.getProject().relativePath((Object)dir)));
            }
        }
        return result;
    }

    private List<WbDependentModule> getEntriesFromConfigurations(Set<Configuration> plusConfigurations, Set<Configuration> minusConfigurations, EclipseWtpComponent wtp, String deployPath, boolean transitive) {
        ArrayList entries = Lists.newArrayList();
        entries.addAll(this.getEntriesFromProjectDependencies(plusConfigurations, minusConfigurations, deployPath, transitive));
        entries.addAll(this.getEntriesFromLibraries(plusConfigurations, minusConfigurations, wtp, deployPath));
        return entries;
    }

    private List<WbDependentModule> getEntriesFromProjectDependencies(Set<Configuration> plusConfigurations, Set<Configuration> minusConfigurations, String deployPath, boolean transitive) {
        Set<Dependency> dependencies = this.getDependencies(plusConfigurations, minusConfigurations, (Spec<Dependency>)Specs.isInstance(ProjectDependency.class));
        ArrayList projects = Lists.newArrayList();
        for (Dependency dependency : dependencies) {
            projects.add(((ProjectDependency)dependency).getDependencyProject());
        }
        LinkedHashSet allProjects = Sets.newLinkedHashSet();
        allProjects.addAll(projects);
        if (transitive) {
            for (Project project : projects) {
                this.collectDependedUponProjects(project, allProjects);
            }
        }
        ArrayList projectDependencies = Lists.newArrayList();
        for (Project project : allProjects) {
            String moduleName = project.getPlugins().hasPlugin(EclipsePlugin.class) ? ((EclipseModel)((Object)project.getExtensions().getByType(EclipseModel.class))).getProject().getName() : project.getName();
            projectDependencies.add(new WbDependentModule(deployPath, "module:/resource/" + moduleName + "/" + moduleName));
        }
        return projectDependencies;
    }

    private void collectDependedUponProjects(Project project, Set<Project> result) {
        Configuration runtimeConfig = (Configuration)project.getConfigurations().findByName("runtime");
        if (runtimeConfig != null) {
            DomainObjectSet projectDeps = runtimeConfig.getAllDependencies().withType(ProjectDependency.class);
            ArrayList dependedUponProjects = Lists.newArrayList();
            for (ProjectDependency projectDep : projectDeps) {
                dependedUponProjects.add(projectDep.getDependencyProject());
            }
            result.addAll(dependedUponProjects);
            for (Project dependedUponProject : dependedUponProjects) {
                this.collectDependedUponProjects(dependedUponProject, result);
            }
        }
    }

    private List<WbDependentModule> getEntriesFromLibraries(Set<Configuration> plusConfigurations, Set<Configuration> minusConfigurations, EclipseWtpComponent wtp, String deployPath) {
        IdeDependenciesExtractor extractor = new IdeDependenciesExtractor();
        Collection<IdeExtendedRepoFileDependency> externals = extractor.resolvedExternalDependencies(plusConfigurations, minusConfigurations);
        Collection<IdeLocalFileDependency> locals = extractor.extractLocalFileDependencies(plusConfigurations, minusConfigurations);
        ArrayList libFiles = Lists.newArrayList();
        for (IdeExtendedRepoFileDependency ideExtendedRepoFileDependency : externals) {
            libFiles.add(ideExtendedRepoFileDependency.getFile());
        }
        for (IdeLocalFileDependency ideLocalFileDependency : locals) {
            libFiles.add(ideLocalFileDependency.getFile());
        }
        ArrayList libraryEntries = Lists.newArrayList();
        for (File file : libFiles) {
            libraryEntries.add(this.createWbDependentModuleEntry(file, wtp.getFileReferenceFactory(), deployPath));
        }
        return libraryEntries;
    }

    private WbDependentModule createWbDependentModuleEntry(File file, FileReferenceFactory fileReferenceFactory, String deployPath) {
        FileReference ref = fileReferenceFactory.fromFile(file);
        String handleSnippet = ref.isRelativeToPathVariable() ? "var/" + ref.getPath() : "lib/" + ref.getPath();
        return new WbDependentModule(deployPath, "module:/classpath/" + handleSnippet);
    }

    private Set<Dependency> getDependencies(Set<Configuration> plusConfigurations, Set<Configuration> minusConfigurations, Spec<Dependency> filter) {
        LinkedHashSet declaredDependencies = Sets.newLinkedHashSet();
        for (Configuration configuration : plusConfigurations) {
            declaredDependencies.addAll(configuration.getAllDependencies().matching(filter));
        }
        for (Configuration configuration : minusConfigurations) {
            declaredDependencies.removeAll((Collection<?>)configuration.getAllDependencies().matching(filter));
        }
        return declaredDependencies;
    }
}

