/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrapper;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapClassLoader
extends URLClassLoader {
    private String[] unmaskedPackages;

    public BootstrapClassLoader(ClassLoader parent, String ... unmaskedPackages) {
        super(new URL[0], parent);
        this.unmaskedPackages = unmaskedPackages;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    boolean canLoadFromParent(String name) {
        for (String pkg : this.unmaskedPackages) {
            if (!name.startsWith(pkg + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.getParent() != null && this.canLoadFromParent(name) ? this.getParent().loadClass(name) : BootstrapClassLoader.getSystemClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                c = this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.findResources(name);
    }
}

