/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.internal.project.antbuilder.AntBuilderDelegate;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.internal.tasks.scala.ScalaCompileOptionsInternal;
import org.gradle.api.internal.tasks.scala.ScalaCompileSpec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.GUtil;
import org.gradle.util.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntScalaCompiler
extends GroovyObjectSupport
implements Compiler<ScalaCompileSpec> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntScalaCompiler.class);
    private final IsolatedAntBuilder antBuilder;
    private final List<File> scalaClasspath;

    public AntScalaCompiler(IsolatedAntBuilder antBuilder, Iterable<File> scalaClasspath) {
        this.scalaClasspath = ImmutableList.copyOf(scalaClasspath);
        this.antBuilder = antBuilder;
    }

    public WorkResult execute(final ScalaCompileSpec spec) {
        File destinationDir = spec.getDestinationDir();
        ScalaCompileOptionsInternal scalaCompileOptions = (ScalaCompileOptionsInternal)spec.getScalaCompileOptions();
        String backend = this.chooseBackend(spec);
        ImmutableMap.Builder optionsBuilder = ImmutableMap.builder();
        optionsBuilder.put((Object)"destDir", (Object)destinationDir);
        optionsBuilder.put((Object)"target", (Object)backend);
        optionsBuilder.putAll(scalaCompileOptions.optionMap());
        if (scalaCompileOptions.internalIsFork()) {
            optionsBuilder.put((Object)"compilerPath", (Object)GUtil.asPath(this.scalaClasspath));
        }
        final ImmutableMap options = optionsBuilder.build();
        final String taskName = scalaCompileOptions.internalUseCompileDaemon() ? "fsc" : "scalac";
        final Iterable compileClasspath = spec.getClasspath();
        LOGGER.info("Compiling with Ant scalac task.");
        LOGGER.debug("Ant scalac task options: {}", (Object)options);
        this.antBuilder.withClasspath(this.scalaClasspath).execute((Closure)new Closure<Object>((Object)this){

            public Object doCall(final AntBuilderDelegate ant) {
                ant.invokeMethod("taskdef", Collections.singletonMap("resource", "scala/tools/ant/antlib.xml"));
                return ant.invokeMethod(taskName, (Object)new Object[]{options, new Closure<Void>((Object)this){

                    public void doCall() {
                        spec.getSource().addToAntBuilder((Object)ant, "src", FileCollection.AntType.MatchingTask);
                        for (File file : compileClasspath) {
                            ant.invokeMethod("classpath", Collections.singletonMap("location", file));
                        }
                    }
                }});
            }
        });
        return new SimpleWorkResult(true);
    }

    private static VersionNumber sniffScalaVersion(Collection<File> classpath) {
        URL[] urls = Collections2.transform(classpath, (Function)new Function<File, URL>(){

            public URL apply(File file) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }).toArray(new URL[0]);
        URLClassLoader classLoader = new URLClassLoader(urls, null);
        try {
            Class<?> clazz = classLoader.loadClass("scala.util.Properties");
            String versionNumber = (String)InvokerHelper.invokeMethod(clazz, (String)"scalaPropOrEmpty", (Object)"maven.version.number");
            return VersionNumber.parse((String)versionNumber);
        }
        catch (ClassNotFoundException ignored) {
            return VersionNumber.UNKNOWN;
        }
        catch (LinkageError ignored) {
            return VersionNumber.UNKNOWN;
        }
    }

    private String chooseBackend(ScalaCompileSpec spec) {
        VersionNumber scalaVersion = AntScalaCompiler.sniffScalaVersion(this.scalaClasspath);
        VersionNumber maxSupported = scalaVersion.compareTo(VersionNumber.parse((String)"2.10.0-M5")) >= 0 ? VersionNumber.parse((String)"1.7") : VersionNumber.parse((String)"1.5");
        VersionNumber target = VersionNumber.parse((String)spec.getTargetCompatibility());
        if (target.compareTo(maxSupported) > 0) {
            target = maxSupported;
        }
        return "jvm-" + target.getMajor() + "." + target.getMinor();
    }
}

